<?php
/*
Plugin Name: Luxe Addons
Plugin URI: http://www.themebubble.com
Description: A part of luxe theme.
Version: 1.1
Author: relstudiosnx
Author URI: http://www.themebubble.com
Text Domain: luxe-addons
*/

defined('RS_ROOT') or define('RS_ROOT', plugin_dir_path( __FILE__ ));

if(!class_exists('RS_Shortcode')) {

  class RS_Shortcode {

    private $assets_css;
    private $assets_js;

    public function __construct() {
      add_action('init',          array($this,'rs_init'),50);
      add_action('setup_theme',   array($this,'rs_load_custom_post_types'),40);
      add_action('widgets_init',  array($this,'rs_load_widgets'),50);
    }

    public static function activate() {
      flush_rewrite_rules();
    }

    public static function deactivate() {
      flush_rewrite_rules();
    }

    public function rs_init() {

      if (!defined('LUXE_THEME_ACTIVATED') || LUXE_THEME_ACTIVATED !== true) {
         add_action( 'admin_notices', array($this,'rs_activate_theme_notice') );
      } else {

        $this->assets_css = plugins_url('/composer/assets/css', __FILE__);
        $this->assets_js  = plugins_url('/composer/assets/js', __FILE__);
        add_action('admin_print_scripts-post.php',      array($this, 'rs_load_vc_scripts'), 99);
        add_action('admin_print_scripts-post-new.php',  array($this, 'rs_load_vc_scripts'), 99);
        add_action('vc_base_register_admin_css',        array($this, 'rs_load_font_icon_css'), 99);
        add_action('vc_load_default_params',            array($this, 'rs_reload_vc_js'));
        add_filter('vc_iconpicker-type-tonicon',        array($this, 'rs_iconpicker_type_tonicon'), 99);
        add_filter('newsletter_enqueue_style',          '__return_false');
        remove_action('hotel_booking_after_single_room', 'hotel_booking_edit_room_link');
        if(class_exists('Vc_Manager')) {
          $this->rs_vc_load_shortcodes();
          $this->rs_init_vc();
          $this->rs_vc_integration();
          //$this->rs_vc_templates();
        }
      }
    }

    function rs_activate_theme_notice() { ?>
      <div class="updated">
        <p><strong><?php esc_html_e('Please activate the Luxe theme to use Luxe Addons plugin.', 'luxe-addons'); ?></strong></p>
        <?php
        $screen = get_current_screen();
        if ($screen -> base != 'themes'): ?>
          <p><a href="<?php echo esc_url(admin_url('themes.php')); ?>"><?php esc_html_e('Activate Theme', 'luxe-addons'); ?></a></p>
        <?php endif; ?>
      </div>
    <?php }

    public function rs_init_vc() {
      global $vc_manager;
      $list = array( 'page', 'post', 'hb_room');
      $vc_manager->setEditorDefaultPostTypes( $list );
    }

    public function rs_load_custom_post_types() {
      require_once(RS_ROOT .'/custom-posts/social-site.php');
      require_once(RS_ROOT .'/custom-posts/testimonial.php');
    }

    public function rs_load_widgets() {
      if (!defined('LUXE_THEME_ACTIVATED') || LUXE_THEME_ACTIVATED !== true) {
        return false;
      }

      $deregister_widgets = array(
        'HB_Widget_Best_Reviews',
        'HB_Widget_Lastest_Reviews',
        'HB_Widget_Room_Carousel',
      );

      foreach ($deregister_widgets as $de_widgets) {
        unregister_widget($de_widgets);
      }

      $widgets = array(
        'WP_Customer_Service_Widget',
        'WP_Contact_Details_Widget',
        'WP_Contact_Form_Cpcp7_Widget',
        'WP_Newsletter_Widget',
        'WP_Popular_Posts_Widget',
      );
      foreach ($widgets as $widget) {
        if (file_exists(RS_ROOT .'/widgets/'.$widget.'.class.php')) {
          require_once(RS_ROOT .'/widgets/'.$widget.'.class.php');
          register_widget('hotelbay_'.$widget);
        }
      }
    }

    public function rs_vc_load_shortcodes() {
      require_once(RS_ROOT. '/' . 'shortcodes/rs_blog.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_hero_slider.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_hero_video_banner.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_section_heading.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_icon_box.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_divider.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_featured_rooms.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_featured_rooms_carousel.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_featured_slider.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_video_banner.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_counter.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_pricing_table.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_testimonial.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_image_gallery.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_tabs.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_accordion.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_animities.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_text_block_with_signature.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_image_block.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_featured_animities_banner.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_text_block_with_button.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_check_list.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_google_map.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_instagram.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_button.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_space.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_special_text.php');
      require_once(RS_ROOT. '/' . 'shortcodes/rs_countdown_timer.php');      
      require_once(RS_ROOT. '/' . 'shortcodes/vc_column_text.php');
    }

    public function rs_vc_integration() {
      require_once( RS_ROOT . '/composer/helpers.php' );
      require_once( RS_ROOT .'/' .'composer/map.php' );
    }

    public function rs_vc_templates() {
      require_once( RS_ROOT .'/' .'composer/templates.php' );
      require_once( RS_ROOT .'/' .'composer/class.vc_template_panel.php' );
      $rs_vc_templates = new RS_VC_Templates();
      return $rs_vc_templates->init();
    }

    public function rs_load_font_icon_css() {
      wp_enqueue_style('rs-font-icon', $this->assets_css. '/tonicons.css');
    }

    public function rs_iconpicker_type_tonicon($icons) {
      $icon_sets =  rs_font_icons();
      return array_merge($icon_sets, $icons);
    }

    public function rs_load_vc_scripts() {
      wp_enqueue_style('rs-vc-custom', $this->assets_css. '/vc-style.css');
      wp_enqueue_style('rs-chosen',    $this->assets_css. '/chosen.css');
      wp_enqueue_script('vc-script',   $this->assets_js . '/vc-script.js' ,      array('jquery'), '1.0.0', true);
      wp_enqueue_script('vc-chosen',   $this->assets_js . '/jquery.chosen.js' ,  array('jquery'), '1.0.0', true);
    }

    public function rs_reload_vc_js() {
      echo '<script type="text/javascript">(function($){ $(document).ready( function(){ $.reloadPlugins(); }); })(jQuery);</script>';
    }
  } 
  new RS_Shortcode;
  register_activation_hook( __FILE__, array( 'RS_Shortcode', 'activate' ) );
  register_deactivation_hook( __FILE__, array( 'RS_Shortcode', 'deactivate' ) );
}


