<?php

/**
 *
 * RS Pricing Table
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_pricing_table($atts, $content = '', $id = '') {

  extract(shortcode_atts(array(
    'id'       => '',
    'class'    => '',
    'plan'     => '',
    'feature'  => '',
    'price'    => '',
    'duration' => 'mo',
    'currency' => '$',
    ''
  ), $atts));

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' ' . luxe_sanitize_html_classes($class) : '';
  
  $output  =  '<div '.$id.' class="hb-pricing'.$class.'">';
  $output .=  '<h4 class="hb-pricing__title">'.esc_html($plan).'</h4>';
  $output .=  '<div class="hb-pricing__count">';
  $output .=  '<span class="hb-pricing__top">'.esc_html($currency).'</span>'.esc_html($price).'<span>'.esc_html($duration).'</span>';
  $output .=  '</div>';
  $output .=  '<ul class="hb-pricing__list">';
  $ex_feature = explode('|', $feature);
  foreach ($ex_feature as $key => $value) {
    $output .=  '<li class="active">'.esc_html($value).'</li>';
  }
  $output .=  '</ul>';
  $output .=  '</div>';


  return $output;
}

add_shortcode('rs_pricing_table', 'rs_pricing_table');



