<?php
/**
 *
 * RS Image Block
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_image_gallery( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'     => '',
    'class'  => '',
    'title'  => '',
    'images' => '',
  ), $atts ) );

  $id         = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class      = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $output = '';
  if(!empty($images)):
    $image_id = explode(',', $images);
    if(is_array($image_id) && isset($image_id)):
      
      $output .= '<div '.$id.' class="block mb-0 block--image-gallery'.$class.'">';
      $output .=  (!empty($title)) ? '<h2 class="block__title">'.esc_html($title).'</h2>':'';
      $output .=  '<div class="block__content">';
      $output .=  '<div class="image-gallery">';
      $output .=  '<div class="image-gallery__main">';

      foreach($image_id as $ids):
        $image_src = rs_get_image_src($ids, 'luxe-large');
        $output .=  '<div class="image-gallery__item"><img src="'.esc_url($image_src).'" alt=""></div>';
      endforeach;
                    
      $output .=  '</div>';
      $output .=  '<ul class="image-gallery__thumbs">';
      foreach($image_id as $ids):
        $image_src_thumb = rs_get_image_src($ids, 'luxe-thumb');
        $output .=  '<li class="image-gallery__thumb"><button class="image-gallery__button"><img src="'.esc_url($image_src_thumb).'" alt=""></button></li>';
      endforeach;
                    
      $output .=  '</ul>';
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
    endif;
  endif;
  return $output;
}

add_shortcode('rs_image_gallery', 'rs_image_gallery');
