<?php

/**
 *
 * Featured Rooms Carousel
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_featured_rooms_carousel($atts, $content = '', $id = '') {
  global $post;
  if(!class_exists('WP_Hotel_Booking')) { return; }
  extract(shortcode_atts(array(
    'id'    => '',
    'class' => '',
    'limit' => 8,
    'cats'  => '',
  ), $atts));

  $class       = ( $class ) ? ' ' .$class : '';
  $class_array = array('lg','md','sm','sm');

  $args = array(
    'posts_per_page' => $limit,
    'post_type'      => 'hb_room',
  );

  $args['tax_query'] = array(
    array(
      'taxonomy' => 'hb_room_type',
      'field'    => 'slug',
      'terms'    => explode(',', $cats),
    ),
  );
  ob_start();

  $the_query = new WP_Query($args); ?>

  <div <?php echo esc_attr($id); ?> class="rooms-slider <?php echo esc_attr($class); ?>">

    <?php 
      while( $the_query->have_posts() ) : $the_query->the_post(); 
      $prices = hb_room_get_selected_plan( get_the_ID() );
      $prices = isset( $prices->prices ) ? $prices->prices : array();
      $image_src = rs_get_image_src(get_post_thumbnail_id(get_the_ID()), 'luxe-medium');

      ?>
    <a href="<?php echo esc_url(get_the_permalink()); ?>" class="rooms-slider__item">
      <div class="rooms-slider__item-wrap">
        <div class="rooms-slider__image"><img src="<?php echo esc_url($image_src); ?>" alt="<?php the_title(); ?>"></div>
        <h3 class="rooms-slider__title"><?php the_title(); ?></h3>
        <?php if(!empty($prices) && is_array($prices)): $min_price = min($prices); ?>
          <?php do_action( 'hotel_booking_loop_room_price' ); ?>
        <?php endif; ?>
      </div>
    </a>
    <?php endwhile; wp_reset_postdata(); ?>

  </div>
  <div class="slick-nav"></div>

  <?php
  $output = ob_get_clean();
  return $output;
}

add_shortcode('rs_featured_rooms_carousel', 'rs_featured_rooms_carousel');
