<?php
/**
 *
 * RS Text Block With Button And Image
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_featured_animities_banner( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'            => '',
    'class'         => '',
    'style'         => 'style1',
    'banner_image'  => '',
    'heading'       => '',
    'btn_text'      => '',
    'btn_link'      => '',
    'bg_color'      => '',
    'heading_color' => '',
    'content_color' => '',
  ), $atts ) );

  $id                  = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class               = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $bg_color_style      = ($bg_color) ? ' style="background-color:'.esc_attr($bg_color).';"':'';
  $heading_color_style = ($heading_color) ? ' style="color:'.esc_attr($heading_color).';"':'';
  $content_color_style = ($content_color) ? ' style="color:'.esc_attr($content_color).';"':'';

  if (function_exists('vc_parse_multi_attribute')) {
    $parse_args = vc_parse_multi_attribute($btn_link);
    $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
    $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
    $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
  }

  $image_src = rs_get_image_src($banner_image);

  switch ($style) {
    default:
    case 'style1':
      $output  =  '<div '.$id.' class="hb-text-block__wrapper style1'.$class.'"'.$bg_color_style.'>';
      $output .=  '<div class="row">';
      $output .=  '<div class="col-md-6">';
      $output .=  '<div class="hb-image__block"><img src="'.esc_url($image_src).'" alt="" /></div>';
      $output .=  '</div>';
      $output .=  '<div class="col-md-6">';
      $output .=  '<div class="hb-text_block_content">';
      $output .=  '<div class="hb-text-block___inner_wrapper">';
      $output .=  '<div class="featured-rooms-slider__title title-color-black"'.$heading_color_style.'>'.wp_kses_post($heading).'</div>';
      $output .=  '<div class="featured-rooms-slider__text content-color-grey"'.$content_color_style.'>'.wp_kses_post($content).'</div>';
      if(!empty($btn_link)):
        $output .=  '<a class="btn btn--md btn--normal" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'">'.esc_html($btn_text).'</a>';
      endif;
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      break;
    case 'style2':
      $output  =  '<div '.$id.' class="hb-text-block__wrapper style2'.$class.'">';
      $output .=  '<div class="row">';
      $output .=  '<div class="col-md-6">';
      $output .=  '<div class="hb-text_block_content">';
      $output .=  '<div class="hb-text-block___inner_wrapper text-right">';
      $output .=  '<div class="featured-rooms-slider__title title-color-black">'.wp_kses_post($heading).'</div>';
      $output .=  '<div class="featured-rooms-slider__text content-color-grey">'.wp_kses_post($content).'</div>';
      if(!empty($btn_link)):
        $output .=  '<a class="btn btn--md btn--normal" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'">'.esc_html($btn_text).'</a>';
      endif;
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '<div class="col-md-6">';
      $output .=  '<div class="hb-image__block"><img src="'.esc_url($image_src).'" alt="" /></div>';
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      break;
  }


  return $output;
}

add_shortcode('rs_featured_animities_banner', 'rs_featured_animities_banner');
