<?php
/**
 *
 * Chart
 * @since 1.0.0
 * @version 1.0.0
 *
 */

function rs_countdown_timer( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'            => '',
    'class'         => '',
    'year'          => '',
    'month'         => '',
    'day'           => '',
    'bg_image'      => '',
    'overlay'       => 'no',
    'small_heading' => '',
    'big_heading'   => '',
    'btn_text'      => '',
    'btn_link'      => ''
  ), $atts ) );

  $id              = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class           = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $overlay_class   = ($overlay == 'yes') ? ' has-overlay':'';
  $data_count_date = '';
  $style_bg        = '';
  $image_url       = rs_get_image_src($bg_image);

  if(!empty($image_url)) {
    $style_bg = ' data-image="'.esc_url($image_url).'"';
  }

  if($year && $month && $day) {
    $data_count_date = ' data-time="'.esc_attr($month).'/'.esc_attr($day).'/'.esc_attr($year).' 00:00:00"';
  }

  if (function_exists('vc_parse_multi_attribute')) {
    $parse_args = vc_parse_multi_attribute($btn_link);
    $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
    $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
    $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
  }

  $output  =  '<div class="jumbotron'.luxe_sanitize_html_classes($overlay_class).$class.'" '.$style_bg.'>';
  $output .=  '<div class="container">';
  $output .=  '<div class="row">';
  $output .=  '<div class="col-md-12 jumbotron-text__content">';
  $output .=  '<div class="subtitle subtitle--lg">'.esc_html($small_heading).'</div>';
  $output .=  '<div class="title title--lg">'.wp_kses_post($big_heading).'</div>';
  $output .=  '<div class="spacing" style="height: 20px"></div>';
  $output .=  '<a class="btn btn--md btn--normal" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'">'.esc_html($btn_text).'</a>';
  $output .=  '<div class="spacing" style="height: 50px"></div>'; 
  $output .=  '<div class="counter-wrap">';
  $output .=  '<div class="counter"'.$data_count_date.' data-translation-days="'.luxe_translate('days', 'Days').'" data-translation-hours="'.luxe_translate('hours', 'Hours').'" data-translation-minutes="'.luxe_translate('minutes', 'Minutes').'" data-translation-seconds="'.luxe_translate('seconds', 'Seconds').'"></div>';
  $output .=  '</div>';
  $output .=  '</div>';
  $output .=  '</div>';
  $output .=  '</div>';
  $output .=  '</div>';
        
  return $output;

}
add_shortcode( 'rs_countdown_timer', 'rs_countdown_timer' );
