<?php
/**
 *
 * RS Button
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_button( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'             => '',
    'class'          => '',
    'type'           => 'solid',
    'btn_text'       => '',
    'btn_link'       => '',
    'align'          => '',
    'font_size'      => '',
    'padding_top'    => '',
    'padding_left'   => '',
    'padding_bottom' => '',
    'padding_right'  => '',
    'bg_color'       => '',
    'text_color'     => '',

  ), $atts ) );

  $id     = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class  = ( $class ) ? ' '. sanitize_html_classes($class) : '';

  if (function_exists('vc_parse_multi_attribute')) {
    $parse_args = vc_parse_multi_attribute($btn_link);
    $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
    $title      = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
    $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
  }
 
  $font_size_attr      = ($font_size) ? ' font-size:'.esc_attr($font_size).';':'';
  $bg_color_attr       = ($bg_color) ? ' background:'.esc_attr($bg_color).';':'';
  $text_color_attr     = ($text_color) ? ' color:'.esc_attr($text_color).';':'';
  $padding_top_attr    = ($padding_top) ? ' padding-top:'.esc_attr($padding_top).';':'';
  $padding_left_attr   = ($padding_left) ? ' padding-left:'.esc_attr($padding_left).';':'';
  $padding_bottom_attr = ($padding_bottom) ? ' padding-bottom:'.esc_attr($padding_bottom).';':'';
  $padding_right_attr  = ($padding_right) ? ' padding-right:'.esc_attr($padding_right).';':'';

  $style_attr = ($font_size_attr || $text_color_attr || $padding_top_attr || $padding_left_attr || $padding_bottom_attr || $padding_right || $bg_color_attr) ? ' style="'.$font_size_attr.$bg_color_attr.$text_color_attr.$padding_top_attr.$padding_left_attr.$padding_bottom_attr.$padding_right_attr.'"':'';

  $output = (!empty($align)) ? '<div class="text-'.$align.'">':'';
  if($type == 'solid'):
    $output .= '<a '.$id.' class="btn btn--md btn--normal'.$class.'" href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'"'.$style_attr.'>'.esc_html($btn_text).'</a>';
  else:
    $output .= '<a href="'.esc_url($href).'" title="'.esc_attr($title).'" target="'.esc_attr($target).'" class="featured-rooms__link btn-text__link"'.$style_attr.'>'.esc_html($btn_text
    ).'</a>';
  endif;
  $output .= (!empty($align)) ? '</div>':'';

  return $output;
}

add_shortcode('rs_button', 'rs_button');
