<?php
/**
 *
 * RS Accordions
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_accordion( $atts, $content = '', $id = '' ) {

  global $rs_accordion_tabs;
  $rs_accordion_tabs = array();

  extract( shortcode_atts( array(
    'id'     => '',
    'class'  => '',
    'active' => 1,

  ), $atts ) );

  do_shortcode( wp_kses_data($content ));

  if( empty( $rs_accordion_tabs ) ) { return; }

  $id        = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class     = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $parent_id = 'parent-'.uniqid();

  $output = '<div '.$id.' class="panel-group mb-0'.$class.'" id="'.esc_attr($parent_id).'" role="tablist" aria-multiselectable="true">';

  foreach ( $rs_accordion_tabs as $key => $tab ) {
    $active_nav = ( ( $key + 1 ) == $active ) ? ' collapse in ' : '';
    $unique_id = 'accordion-'.uniqid();
    $output .=  '<div class="panel panel-default">';
    $output .=  '<div class="panel-heading" role="tab">';
    $output .=  '<h4 class="panel-title">';
    $output .=  '<a role="button" data-toggle="collapse" data-parent="#'.esc_attr($parent_id).'" href="#'.$unique_id.'" aria-expanded="false" aria-controls="'.$unique_id.'">'.esc_html($tab['atts']['title']).'</a>';
    $output .=  '</h4>';
    $output .=  '</div>';
    $output .=  '<div id="'.$unique_id.'" class="panel-collapse'.$active_nav.'" role="tabpanel">';
    $output .=  '<div class="panel-body">';
    $output .=  do_shortcode((wp_kses_data($tab['content'])) );
    $output .=  '</div>';
    $output .=  '</div>';
    $output .=  '</div>';
  }

  $output .=  '</div>';

  return $output;
}

add_shortcode('vc_accordion', 'rs_accordion');


/**
 *
 * RS Accordion
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_accordion_tab( $atts, $content = '', $id = '' ) {
  global $rs_accordion_tabs;
  $rs_accordion_tabs[]  = array( 'atts' => $atts, 'content' => $content );
  return;
}

add_shortcode('vc_accordion_tab', 'rs_accordion_tab');
