<?php
/**
 * Testimonial custom posty type
 */
$labels = array(
  'name'               => esc_html__( 'Testimonials', 'luxe-addons' ),
  'singular_name'      => esc_html__( 'Testimonial', 'luxe-addons' ),
  'add_new'            => esc_html__( 'Add New', 'luxe-addons' ),
  'add_new_item'       => esc_html__( 'Add New Testimonials', 'luxe-addons' ),
  'edit_item'          => esc_html__( 'Edit Testimonials', 'luxe-addons' ),
  'new_item'           => esc_html__( 'New Testimonials', 'luxe-addons' ),
  'all_items'          => esc_html__( 'All Testimonials', 'luxe-addons' ),
  'view_item'          => esc_html__( 'View Testimonials', 'luxe-addons' ),
  'search_items'       => esc_html__( 'Search Testimonials', 'luxe-addons' ),
  'not_found'          => esc_html__( 'No Testimonials found', 'luxe-addons' ),
  'not_found_in_trash' => esc_html__( 'No Testimonials found in Trash', 'luxe-addons' ),
  'parent_item_colon'  => '',
  'menu_name'          => esc_html__( 'Testimonials', 'luxe-addons' )
);

 $args = array(
  'labels'        => $labels,
  'public'        => false,
  'show_ui'       => true,
  'menu_position' => 30,
  'supports'      => array( 'title', 'thumbnail', 'editor' ),
  'has_archive'   => true,
   'rewrite' => array(
    'slug' => 'cpt-testimonial'
  )
);

register_post_type ( 'testimonial', $args);

/**
 * Testimonial category
 */

$labels = array(
  'name'              => _x( 'Categories', 'taxonomy general name', 'luxe-addons' ),
  'singular_name'     => _x( 'Category', 'taxonomy singular name', 'luxe-addons' ),
  'search_items'      => esc_html__( 'Search categories', 'luxe-addons' ),
  'all_items'         => esc_html__( 'All Categories', 'luxe-addons' ),
  'parent_item'       => esc_html__( 'Parent Category', 'luxe-addons' ),
  'parent_item_colon' => esc_html__( 'Parent Category:', 'luxe-addons' ),
  'edit_item'         => esc_html__( 'Edit Category', 'luxe-addons' ),
  'update_item'       => esc_html__( 'Update Category', 'luxe-addons' ),
  'add_new_item'      => esc_html__( 'Add New Category', 'luxe-addons' ),
  'new_item_name'     => esc_html__( 'New Category Name', 'luxe-addons' ),
  'menu_name'         => esc_html__( 'Categories' ),
);
$args = array(
  'labels' => $labels,
  'hierarchical' => true,
);
register_taxonomy( 'testimonial-category', 'testimonial', $args );
