<?php
/**
 * The Template for displaying all single products
 *
 * Override this template by copying it to yourtheme/tp-hotel-booking/single-room.php
 *
 * @author        ThimPress
 * @package       wp-hotel-booking/templates
 * @version       1.6
 */

if ( !defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}
get_header(); ?>

<?php
  /**
   * hotel_booking_single_page_header
   */
  do_action( 'hotel_booking_single_page_header');
?>

<div class="container">
  <div class="marg-lg-b100 marg-xs-b50"></div>
  <?php
    /**
     * hotel_booking_before_main_content hook
     */
    do_action( 'hotel_booking_before_main_content' );
  ?>
  
  <?php get_template_part('theme/inc/global/page-before-content'); ?>
  <?php 
    while ( have_posts() ) : the_post(); 
      hb_get_template_part( 'content', 'single-room' );
    endwhile;
  ?>
  <?php get_template_part('theme/inc/global/page-after-content'); ?>
  <?php
    /**
     * hotel_booking_after_main_content hook
     *
     * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
     */
    do_action( 'hotel_booking_after_main_content' );
  ?>
  <div class="marg-lg-b100 marg-xs-b50"></div>
</div>


<?php get_footer(); ?>