<?php
/**
 * Display single room reviews (comments)
 *
 * Override this template by copying it to yourtheme/tp-hotel-booking/single-room-reviews.php
 *
 * @author        ThimPress
 * @package       wp-hotel-booking/templates
 * @version       1.6
 */
if ( !defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly
}


global $hb_room;
global $hb_settings;
$hotel_review_on_ff = luxe_get_opt('single-room-review');
if ( !comments_open() || !$hotel_review_on_ff ) {
  return;
}
?>
<div id="reviews">
  <div id="comments" class="block">
      <h2 class="block__title">
        <?php
        if ( $hb_settings->get( 'enable_review_rating' ) && ( $count = $hb_room->get_review_count() ) )
          printf( _n( '%s review for %s', '%s reviews for %s', $count, 'luxe' ), $count, get_the_title() );
        else
          esc_html_e( 'Reviews', 'luxe' );
        ?>
       </h2>

      <div class="block__content">
      <?php if ( have_comments() ) : ?>
        <ol class="comments">
          <?php wp_list_comments( apply_filters( 'hb_room_review_list_args', array( 'callback' => 'hb_comments' ) ) ); ?>
        </ol>
        <button class="comments-more">Load more comments</button>
        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
          echo '<nav class="hb-pagination">';
          paginate_comments_links( apply_filters( 'hb_comment_pagination_args', array(
            'prev_text' => '&larr;',
            'next_text' => '&rarr;',
            'type'      => 'list',
          ) ) );
          echo '</nav>';
        endif; ?>

      <?php else : ?>

              <p class="hb-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'luxe' ); ?></p>

      <?php endif; ?>
    </div>
  </div><!--end of block-->

  <?php if ( hb_customer_booked_room( $hb_room->id ) ) : ?>

        <div id="review_form_wrapper" class="block">
            <div id="review_form">
        <?php
        $commenter    = wp_get_current_commenter();
        $comment_form = array(
          'title_reply'          => have_comments() ? esc_html__( 'Add a review', 'luxe' ) : esc_html__( 'Be the first to review', 'luxe' ) . ' &ldquo;' . get_the_title() . '&rdquo;',
          'title_reply_to'       => __( 'Leave a Reply to %s', 'luxe' ),
          'comment_notes_before' => '',
          'comment_notes_after'  => '',
          'class_submit'         => 'btn',
          'class_form'           => 'block__content',
          'fields'               => array(
            'author' => '<div class="row"><div class="col-md-6"><div class="comment-form-author input--user">' .
              '<input id="author" name="author" class="input__field" placeholder="'.esc_attr__('Name', 'luxe').'" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
            'email'  => '<div class="col-md-6"><div class="comment-form-email input--email">' .
              '<input id="email" name="email" class="input__field" placeholder="'.esc_attr__('Email', 'luxe').'" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div></div>',
          ),
          'label_submit'         => esc_html__( 'Add Review', 'luxe' ),
          'logged_in_as'         => '',
          'comment_field'        => ''
        );

        if ( $hb_settings->get( 'enable_review_rating' ) ) {
          $comment_form['comment_field'] = '<p class="comment-form-rating"><label for="rating">' . esc_html__( 'Your Rating', 'luxe' ) . '</label>
                        </p><div class="hb-rating-input"></div>';
        }

        $comment_form['comment_field'] .= '<div class="comment-form-comment input--textarea"><textarea placeholder="'.esc_attr__('Your Comment', 'luxe').'" id="comment" name="comment" class="input__field" cols="45" rows="8" aria-required="true"></textarea></div>';
        comment_form( apply_filters( 'hb_product_review_comment_form_args', $comment_form ) );
        ?>
            </div>
        </div>

  <?php else : ?>

        <p class="hb-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'luxe' ); ?></p>

  <?php endif; ?>

    <div class="clear"></div>
</div>
