<?php
/**
 * Header Template file
 *
 * @package luxe
 * @since 1.0
 */
?>

<header class="site-header hb-header__style4">
  <?php luxe_top_header(); ?>
  <div class="nav-bar">
    <div class="container">
      <div class="nav-bar__item nav-bar__item--logo">
        <div class="site-logo">
           <?php luxe_logo('logo', 'hb-logo__logo__1x', get_theme_file_uri('assets/images/logo.png')); ?>
           <?php luxe_logo('logo-2x', 'hb-logo__logo__2x', get_theme_file_uri('assets/images/logo@2x.png', true)); ?>
        </div>
      </div>

      <div class="nav-bar__item nav-bar__item--menu">
        <?php luxe_main_menu('site-menu'); ?>
      </div>

      <div class="nav-bar__item nav-bar__item--mobile">
        <button class="btn btn--mobile-toggle"><i class="fa fa-bars"></i></button>
      </div>

      <?php $header_btn_enable = luxe_get_opt('header-btn-enable-switch'); if(class_exists('ReduxFramework') && $header_btn_enable): ?>
        <div class="nav-bar__item nav-bar__item--btn">
          <a href="<?php echo esc_url(luxe_get_opt('header-btn-link')); ?>" class="header-btn btn btn--site btn--style-2"><?php echo luxe_get_opt('header-btn-text'); ?></a>
        </div>
      <?php endif; ?>

    </div>
  </div>
</header>
