<?php
/**
 * Blog Default
 *
 * @package luxe
 * @since 1.0
 */
?>
<?php
  global $post;
  $img_src       = luxe_get_image_src(get_post_thumbnail_id($post->ID), 'full');
  $author_avatar = luxe_get_opt('single-post-author-avatar');
  $author_name   = luxe_get_opt('single-post-author-name');
  $post_date     = luxe_get_opt('single-post-post-date');
  $post_tags     = luxe_get_opt('single-post-tags');
  if(!empty($img_src)):
?>

<div class="page-header" data-parallax="scroll" data-image-src="<?php echo esc_url($img_src); ?>">
  <div class="container">
    <div class="page-header__wrap text-center">
      <div class="page-header__col page-header__col--title">
        <h1 class="page-title"><?php the_title(); ?></h1>
        <div class="text-center">
          <div class="tt-blog-user clearfix">
            <?php if($author_avatar): ?>
              <a class="tt-blog-user-img" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' )); ?>">
                <?php echo get_avatar( get_the_author_meta('ID'), 40 ); ?>
              </a>
            <?php endif; ?>
            <div class="tt-blog-user-content">
              <?php if($author_name): ?>
                <span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' )); ?>"><?php echo get_the_author_meta('display_name', $post->post_author); ?></a></span>
              <?php endif; ?>
              <?php if($post_date): ?>
                <span><?php echo get_the_date(get_option('date_format')); ?></span>
              <?php endif; ?>
            </div>
          </div>                            
        </div>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>


<div class="content">
  <div class="marg-lg-b100 marg-md-b50 marg-xs-b50"></div>
  <div class="container">
    <?php get_template_part('theme/inc/global/page-before-content'); ?>
    <?php if(empty($img_src)): ?>
      <div class="blog-page__title__wrapper">
        <div class="blog-page__title">
          <h1 class="page-title"><?php the_title(); ?></h1>
        </div>
        <div class="tt-blog-user clearfix">
          <?php if($author_avatar || !class_exists('ReduxFramework')): ?>
            <a class="tt-blog-user-img" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' )); ?>">
              <?php echo get_avatar( get_the_author_meta('ID'), 40 ); ?>
            </a>
          <?php endif; ?>
          <div class="tt-blog-user-content">
            <?php if($author_name || !class_exists('ReduxFramework')): ?>
              <span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' )); ?>"><?php echo get_the_author_meta('display_name', $post->post_author); ?></a></span>
            <?php endif; ?>
            <?php if($post_date || !class_exists('ReduxFramework')): ?>
              <span><?php echo get_the_date(get_option('date_format')); ?></span>
            <?php endif; ?>
          </div>
        </div> 
      </div>  
    <?php endif; ?>
    <?php while ( have_posts() ) : the_post(); ?>
      <article <?php post_class(); ?>>
        <?php luxe_blog_post_format(); ?>
        <div class="block">
          <div class="block__content">
             <?php the_content(); ?>
          </div>
        </div>
        <?php
          wp_link_pages( array(
            'before'      => '<div class="block"><div class="page-links block__content">' . esc_html__( 'Pages:', 'luxe' ),
            'after'       => '</div></div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
          ) );
        ?>
      </article>
        <?php 
          if($post_tags || !class_exists('ReduxFramework')):
            the_tags( '<div class="block"><h2 class="block__title">'.esc_html__('Tags:', 'luxe').'</h2><div class="block__content">', ', ', '</div></div>' ); 
          endif;
        ?>
    <?php endwhile; ?>
    <?php
      if (comments_open() || get_comments_number()) :
        comments_template();
      endif;
    ?>
    <?php get_template_part('theme/inc/global/page-after-content'); ?>
  </div>
  <div class="marg-lg-b100 marg-md-b50 marg-xs-b50"></div>
</div>