<?php
/**
 * Filter Hooks
 *
 * @package make
 * @since 1.0
 */

if (! function_exists('luxe_wp_title') ) {
  /**
   * Title Filter
   *
   * @package make
   * @since 1.0
   */
  function luxe_wp_title( $title, $sep ) {
    global $paged, $page;

    if ( is_feed() ) {
      return $title;
    } // end if

    // Add the site name.
    $title .= get_bloginfo( 'name' );

    // Add the site description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) ) {
      $title = "$title $sep $site_description";
    } // end if

    // Add a page number if necessary.
    if ( $paged >= 2 || $page >= 2 ) {
      $title = sprintf( __( 'Page %s', 'luxe' ), max( $paged, $page ) ) . " $sep $title";
    } // end if

    return $title;

  } // end rs_wp_title
  add_filter( 'wp_title', 'luxe_wp_title', 10, 2 );
}

if(!function_exists('luxe_upload_svg')) {
  /**
   * Allow xml file to upload
   *
   * @package adios
   * @since 1.0
   */
  function luxe_upload_svg($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter('upload_mimes', 'luxe_upload_svg');
}


if( !function_exists('luxe_body_class')) {
  /**
   * Body Filter Hook
   *
   * @package make
   * @since 1.0
   */
  function luxe_body_class($classes) {
    global $post;
    $classes[] = '';
    $classes[] = luxe_get_opt('page-layout');
    return $classes;
  }
  add_filter('body_class', 'luxe_body_class');
}

if(!function_exists('luxe_instagram_ul_filter')) {
  /**
   * luxe_instagram_ul_filter
   *
   * @package make
   * @since 1.0
   */
  function luxe_instagram_ul_filter($classes) {
    return 'instragram-feed-wrap';
  }
  add_filter( 'wpiw_list_class', 'luxe_instagram_ul_filter' );
}