<?php
/**
 * Action Hooks.
 *
 * @package luxe
 * @since 1.0
*/
if( !function_exists('luxe_after_setup')) {
  /**
  * @return null
  * @param none
  * luxe_after_setup
  **/
  function luxe_after_setup() {
    define('LUXE_THEME_ACTIVATED', true);
    add_image_size('luxe-large',       748, 400,  true );
    add_image_size('luxe-medium',      368, 268,  true );
    add_image_size('luxe-medium-alt',  570, 432,  true );
    add_image_size('luxe-medium-hor',  570, 201,  true );
    add_image_size('luxe-small',       270, 201,  true );
    add_image_size('luxe-thumb',       178, 95,  true );
    add_image_size('luxe-thumb-small', 61, 60,  true );
    add_theme_support('post-thumbnails');
    add_theme_support('custom-background');
    add_theme_support('automatic-feed-links' );
    add_theme_support('post-formats', array('gallery', 'audio') );
    add_theme_support('title-tag');
    add_theme_support('wp-block-styles');
    add_theme_support('responsive-embeds');

    load_theme_textdomain('luxe', get_theme_file_uri('languages'));

    register_nav_menus (array(
      'primary-menu' => esc_html__( 'Main Menu', 'luxe' ),
    ) );
  }
  add_action( 'after_setup_theme', 'luxe_after_setup' );
}

if(!function_exists('luxe_enqueue_scripts')) {
  function luxe_enqueue_scripts() {
    if(( is_admin())) { return; }

    if (is_singular()) { wp_enqueue_script( 'comment-reply' ); }

    $google_map_api = luxe_get_opt('google-map-api');

    wp_enqueue_script('isotope',     get_theme_file_uri('assets/js/jquery.isotope.min.js'),       array('jquery'), '1.0.0', true);
    wp_enqueue_script('match',       get_theme_file_uri('assets/js/jquery.matchHeight.js'),       array('jquery'), '1.0.0', true);
    wp_enqueue_script('jquery-ui',   get_theme_file_uri('assets/js/jquery-ui.min.js'),            array('jquery'), '1.0.0', true);
    wp_enqueue_script('bootstrap',   get_theme_file_uri('assets/js/bootstrap.min.js'),            array('jquery'), '1.0.0', true);
    wp_enqueue_script('slick',       get_theme_file_uri('assets/js/slick.min.js'),                array('jquery'), '1.0.0', true);
    wp_enqueue_script('parallax',    get_theme_file_uri('assets/js/parallax.min.js'),             array('jquery'), '1.0.0', true);
    wp_enqueue_script('countdown',   get_theme_file_uri('assets/js/jquery.countdown.min.js'),     array('jquery'), '1.0.0', true);
    if(!empty($google_map_api)):
      wp_register_script('gmapsensor',  'http://maps.google.com/maps/api/js?key='.esc_attr($google_map_api),        array('jquery'), '1.0.0', true);
      wp_register_script('gmap3',         get_theme_file_uri('assets/js/gmap3.min.js'),        array('gmapsensor'), '1.0.0', true);
    endif;
    wp_register_script('ytplayer',        get_theme_file_uri('assets/js/jquery.mb.YTPlayer.min.js'),        array('jquery'), '1.0.0', true);
    wp_enqueue_script('imagesloaded');
    wp_enqueue_script('luxe-main',        get_theme_file_uri('assets/js/main.js'),                   array('jquery'), '1.0.0', true);


    wp_enqueue_style('luxe-fonts-google',   luxe_fonts_url(), null, '1.0.0');
    wp_enqueue_style('bootstrap',           get_theme_file_uri('assets/css/bootstrap.css'),               null, '1.0.0');
    wp_enqueue_style('fontawesome',         get_theme_file_uri('assets/css/font-awesome.min.css'),        null, '1.0.0');
    wp_enqueue_style('tonicon',             get_theme_file_uri('assets/css/tonicons.css'),                null, '1.0.0');
    wp_enqueue_style('slick',               get_theme_file_uri('assets/css/slick.css'),                   null, '1.0.0');
    wp_register_style('ytplayer',           get_theme_file_uri('assets/css/jquery.mb.YTPlayer.min.css'),  null, '1.0.0');
    wp_enqueue_style('luxe-style',          get_theme_file_uri('assets/css/core.css'),                    null, '1.0.0');

    if(is_rtl()):
      wp_enqueue_style('rtl',               get_theme_file_uri('assets/css/core-rtl.css'),  null, '1.0.0');
    endif;

    $accent_code = luxe_accent_css();
    $style       = (!empty($accent_code)) ? $accent_code:'';

    wp_add_inline_style('luxe-style', $style);

  }
  add_action('wp_enqueue_scripts', 'luxe_enqueue_scripts');
}

if(!function_exists('luxe_set_homepage_menu')) {
  /**
   * Set up homepage and menu
   *
   * @package luxe
   * @since 1.0
   */
  function luxe_set_homepage_menu($demo_active_import, $demo_directory_path) {
    reset( $demo_active_import );
    $current_key = key( $demo_active_import );
    $wbc_menu_array = array( 
      'Elegant',
      'Villa',
      'Bread and Breakfast',
      'Motel',
      'Resort',
      'Boutique',
      'Luxury',
      'Apartment',
      'Video'
    );
    if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
      $locations = get_nav_menu_locations();
      $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

      if (isset($main_menu->term_id)) {
        set_theme_mod( 'nav_menu_locations', array(
          'primary-menu' => $main_menu->term_id,
        ));
      }
    }

    $wbc_home_pages = array(
      'Elegant'             => 'Home',
      'Apartment'           => 'Home',
      'Villa'               => 'Home',
      'Bread and Breakfast' => 'Home',
      'Luxury'              => 'Home',
      'Resort'              => 'Home',
      'Motel'               => 'Home',
      'Boutique'            => 'Home',
      'Video'               => 'Home'
    );
    if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
      $page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
      if ( isset( $page->ID ) ) {
        update_option( 'page_on_front', $page->ID );
        update_option( 'show_on_front', 'page' );
      }
    }
  }
  add_action( 'wbc_importer_after_content_import', 'luxe_set_homepage_menu', 10, 2 );
}

if ( !function_exists( 'luxe_after_content_import' ) ) {
  /**
   * Inactive default widgets after import
   *
   * @package luxe
   * @since 1.0
   */
  function luxe_after_content_import( $demo_active_import , $demo_data_directory_path ) {
    $inactive = array();
    $sidebars = wp_get_sidebars_widgets();

    if( isset( $sidebars['wp_inactive_widgets'] ) ) {
      $inactive = $sidebars['wp_inactive_widgets'];
      unset( $sidebars['wp_inactive_widgets'] );
    }

    foreach ( $sidebars as $sidebar => $widgets ) {
      if(is_array($widgets)):
        $inactive = array_merge( $inactive, $widgets );
      endif;
      $sidebars[$sidebar] = array();
    }

    $sidebars['wp_inactive_widgets'] = $inactive;

    wp_set_sidebars_widgets( $sidebars );
  }

  add_action( 'wbc_importer_after_content_import', 'luxe_after_content_import', 10, 2 );
}

if( !function_exists('luxe_register_sidebar') ) {
  /**
  * @return null
  * @param none
  * register widgets
  **/
  function luxe_register_sidebar() {
    register_sidebar(array(
      'id'            => 'main',
      'name'          => 'Main Sidebar',
      'before_widget' => '<div id="%1$s" class="sidebar-item widget %2$s">',
      'after_widget'  => '</div>',
      'before_title'  => '<h5 class="h5 widget-title">',
      'after_title'   => '</h5>',
      'description'   => 'Drag the widgets for main sidebars.'
    ));

    for($i = 1; $i < 5; $i++) {
      register_sidebar(array(
        'id'            => 'footer-'.$i,
        'name'          => 'Footer Sidebar '.$i,
        'before_widget' => '<div id="%1$s" class="widget footer_widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
        'description'   => 'Drag the widgets for sidebars.'
      ));
    }

    $custom_sidebars = luxe_get_opt('custom-sidebars');
    if (is_array($custom_sidebars)) {
      foreach ($custom_sidebars as $sidebar) {

        if (empty($sidebar)) {
          continue;
        }

        register_sidebar ( array (
          'name'          => $sidebar,
          'id'            => sanitize_title ( $sidebar ),
          'before_widget' => '<div id="%1$s" class="sidebar-item widget %2$s">',
          'after_widget'  => '</div>',
          'before_title'  => '<h5 class="h5 widget-title">',
          'after_title'   => '</h5>',
          'description'   => 'Drag the widgets for custom sidebars.'
        ) );
      }
    }
  }
  add_action( 'widgets_init', 'luxe_register_sidebar' );
}

if(! function_exists('luxe_include_required_plugins')) {
  /**
  * @return null
  * @param none
  * tgm_include
  **/
  function luxe_include_required_plugins() {

    $plugins = array(

      array(
        'name'               => 'Redux Framework',
        'slug'               => 'redux-framework',
        'required'           => true,
        'force_activation'   => false,
        'force_deactivation' => false,
      ),
      array(
        'name'               => esc_html__('Contact Form 7', 'luxe'), // The plugin name
        'slug'               => 'contact-form-7', // The plugin slug (typically the folder name)
        'required'           => false, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('Redux Addons', 'luxe'), // The plugin name
        'slug'               => 'redux-addons', // The plugin slug (typically the folder name)
        'source'             => get_template_directory_uri().'/plugins/redux-addons.zip', // The plugin source
        'required'           => true, // If false, the plugin is only 'recommended' instead of required
        'version'            => '1.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('Luxe Addons', 'luxe'), // The plugin name
        'slug'               => 'luxe-addons', // The plugin slug (typically the folder name)
        'source'             => get_template_directory_uri().'/plugins/luxe-addons.zip', // The plugin source
        'required'           => true, // If false, the plugin is only 'recommended' instead of required
        'version'            => '1.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('Newsletter', 'luxe'), 
        'slug'               => 'newsletter',   
        'required'           => false, 
        'force_activation'   => false, 
        'force_deactivation' => false, 
        'external_url'       => '', 
      ),
      array(
        'name'               => esc_html__('Instagram', 'luxe'), 
        'slug'               => 'wp-instagram-widget', 
        'required'           => false, 
        'version'            => '', 
        'force_activation'   => false, 
        'force_deactivation' => false, 
        'external_url'       => '', 
      ),
      array(
        'name'               => esc_html__('WP Hotel Booking', 'luxe'), // The plugin name
        'slug'               => 'wp-hotel-booking', // The plugin slug (typically the folder name)
        'required'           => true, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('WP Hotel Booking Coupon', 'luxe'), // The plugin name
        'slug'               => 'wp-hotel-booking-coupon', // The plugin slug (typically the folder name)
        'required'           => false, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('WP Hotel Booking Stripe Payment', 'luxe'), // The plugin name
        'slug'               => 'wp-hotel-booking-stripe-payment', // The plugin slug (typically the folder name)
        'required'           => false, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('WP Hotel Booking Authorize Payment', 'luxe'), // The plugin name
        'slug'               => 'wp-hotel-booking-authorize-payment', // The plugin slug (typically the folder name)
        'required'           => false, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('WP Hotel Booking Block Room', 'luxe'), // The plugin name
        'slug'               => 'wp-hotel-booking-block-room', // The plugin slug (typically the folder name)
        'required'           => false, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('WP Hotel Booking Report', 'luxe'), // The plugin name
        'slug'               => 'wp-hotel-booking-report', // The plugin slug (typically the folder name)
        'required'           => false, // If false, the plugin is only 'recommended' instead of required
        'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
      array(
        'name'               => esc_html__('Visual Composer', 'luxe'), // The plugin name
        'slug'               => 'js_composer', // The plugin slug (typically the folder name)
        'source'             =>  get_template_directory_uri().'/plugins/js_composer.zip', // The plugin source
        'required'           => true, // If false, the plugin is only 'recommended' instead of required
        'version'            => '5.4.7', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'       => '', // If set, overrides default API URL and points to an external URL
      ),
    );

    $config = array(
      'id'           => 'luxe',                   // Unique ID for hashing notices for multiple instances of TGMPA.
      'default_path' => '',                      // Default absolute path to bundled plugins.
      'menu'         => 'tgmpa-install-plugins', // Menu slug.
      'parent_slug'  => 'themes.php',            // Parent menu slug.
      'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
      'has_notices'  => true,                    // Show admin notices or not.
      'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
      'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
      'is_automatic' => false,                   // Automatically activate plugins after installation or not.
      'message'      => '',                      // Message to output right before the plugins table.
    );

    tgmpa( $plugins, $config );

  }
  add_action( 'tgmpa_register', 'luxe_include_required_plugins' );
}
