<?php
/**
 * Helper Functions
 *
 * @package luxe
 * @since 1.0
*/
if( ! function_exists( 'luxe_inline_id' ) ) {
  /**
   *
   * Inline ID Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_inline_id( $id = '' ) {
    echo luxe_get_inline_id( $id );
  }
}

if( ! function_exists( 'luxe_get_inline_id' ) ) {
  /**
   *
   * Inline ID Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_get_inline_id( $id = '' ) {
    return ( $id != '' ) ? ' id="'. esc_attr( $id ) .'"' : '';
  }
}

if( ! function_exists( 'luxe_inline_class' ) ) {
  /**
   *
   * Inline Class Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_inline_class( $atts = array(), $include_class = true ) {
    echo luxe_get_inline_class( $atts, $include_class = true );
  }
}

if( ! function_exists( 'luxe_get_inline_class' ) ) {
  /**
   *
   * Inline Class Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_get_inline_class( $atts, $include_class = true ) {

    if( empty( $atts ) ) { return; }

    $output = '';
    $class  = array();

    if( is_array( $atts ) ) {
      foreach( $atts as $key => $value ) {
        if( is_numeric( $key ) ) {
          $class = explode( ' ', $value );
        } else if( $value ) {
          $class[] = $key;
        } else if( $key === 'custom') {
          $class[] = $value;
        }

      }
    } else {
      $class = explode( ' ', $atts );
    }

    if( ! empty( $class ) ) {

      $classes = join( ' ', sanitize_html_class( $class ) );
      $output  = ( $include_class ) ? ' class="'. $classes .'"' : ' '. $classes;

    }

    return $output;

  }
}

if( ! function_exists( 'luxe_inline_style' ) ) {
  /**
   *
   * Inline Style Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_inline_style( $atts = array() ) {
    echo luxe_get_inline_style( $atts );
  }
}
if( ! function_exists( 'luxe_get_inline_style' ) ) {
  /**
   *
   * Inline Style Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_get_inline_style( $atts = array() ) {

    if( empty( $atts ) ) { return; }

    $style = '';

    foreach( $atts as $key => $value ) {

      if( isset( $value ) && $value != '' && $key != 'custom' ) {
        $style .= $key .':'. $value .';';
      }

      if( $key == 'custom' ) {
        $style .= $value;
      }

    }

    $style = ( ! empty( $style ) ) ? ' style="'. esc_attr( $style ) .'"' : '';

    return $style;

  }
}

if( ! function_exists( 'luxe_inline_html5_data' ) ) {
  /**
   *
   * Inline HTML5 Data Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_inline_html5_data( $atts = array() ) {
    echo luxe_get_inline_html5_data( $atts );
  }
}

if( ! function_exists( 'luxe_get_inline_html5_data' ) ) {
  /**
   *
   * Inline HTML5 Data Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_get_inline_html5_data( $atts = array() ) {

    if( empty( $atts ) ) { return; }

    $data = array();

    foreach( $atts as $key => $value ) {

      if( isset( $value ) && (string) $value != '' && $key != 'custom' ) {
        $data[] = 'data-'. esc_attr( $key ) .'="'. esc_attr( $value ) .'"';
      }

      if( $key == 'custom' ) {
        $data[] = $value;
      }

    }

    return ( ! empty( $data ) ) ? join( ' ', $data ) : '';

  }
}

if( ! function_exists( 'luxe_inline_html_tag' ) ) {
  /**
   *
   * Inline HTML Tag Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_inline_html_tag( $atts = array() ) {
    echo luxe_get_inline_html_tag( $atts );
  }
}
if( ! function_exists( 'luxe_get_inline_html_tag' ) ) {
  /**
   *
   * Inline HTML Tag Parser
   *
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_get_inline_html_tag( $atts = array() ) {

    if( empty( $atts ) ) { return; }

    $tag = '';

    foreach( $atts as $key => $value ) {

      if( isset( $value ) && $value != '' && $key != 'custom' ) {
        $tag .= ' '. $key .'="'. esc_attr( $value ) .'"';
      }

      if( $key == 'custom' ) {
        $tag .= ' '. $value;
      }

    }

    return ( ! empty( $tag ) ) ? $tag : '';

  }
}


if ( ! function_exists( 'luxe_post_excerpt' ) ) {
  /**
   *
   * Blog Excerpt Read More
   * @since 1.7.0
   * @version 1.0.0
   *
   */
  function luxe_post_excerpt( $limit = '', $content = '' ) {
    $limit   = ( empty($limit)) ? 20:$limit;
    $content = (empty($content)) ? get_the_excerpt():$content;
    $content = strip_shortcodes( $content );
    $content = str_replace( ']]>', ']]&gt;', $content );
    $content = strip_tags( $content );
    $words   = explode( ' ', $content, $limit + 1 );

    if( count( $words ) > $limit ) {

      array_pop( $words );
      $content  = implode( ' ', $words );
      $content .= ' ...';

    }

    return $content;

  }
}

if ( ! function_exists( 'luxe_sanitize_html_classes' ) && function_exists( 'sanitize_html_class' ) ) {
  /**
  *
  * @return none
  * @param  class
  * multiple class sanitization
  *
  **/
  function luxe_sanitize_html_classes( $class, $fallback = null ) {

    if ( is_string( $class ) ) {
      $class = explode(" ", $class);
    }

    if ( is_array( $class ) && count( $class ) > 0 ) {
      $class = array_map("sanitize_html_class", $class);
      return implode(" ", $class);
    }
    else {
      return sanitize_html_class( $class, $fallback );
    }
  }
}

if ( ! function_exists( 'luxe_paging_nav' ) ) {
  /**
   *
   * Pagination
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_paging_nav( $max_num_pages = false) {

    if (get_query_var('paged')) {
      $paged = get_query_var('paged');
    } elseif (get_query_var('page')) {
      $paged = get_query_var('page');
    } else {
      $paged = 1;
    }

    if ($max_num_pages === false) {
      global $wp_query;
      $max_num_pages = $wp_query->max_num_pages;
    }

    $big = 999999999; 

    $links = paginate_links( array(
      'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
      'format'    => '?paged=%#%',
      'current'   => $paged,
      'total'     => $max_num_pages,
      'prev_next' => false,
      'end_size'  => 1,
      'mid_size'  => 2,
      'type'      => 'plain',
    ) );

    if (!empty($links)): ?>
      <div class="blog-nav">
        <?php echo wp_kses_post($links); ?>
      </div>
    <?php endif;

  }
}

if(!function_exists('luxe_header_template')) {
  /**
   * luxe Header Template
   * @since luxe 1.0
  */
  function luxe_header_template($layout) {
    switch ($layout) {
      case 'header-style4':
        get_template_part('theme/inc/header/header-style4');
        break;
      case 'header-style3':
        get_template_part('theme/inc/header/header-style3');
        break;
      case 'header-style2':
        get_template_part('theme/inc/header/header-style2');
        break;
      case 'header-style1':
      default:
        get_template_part('theme/inc/header/header-style1');
        break;
    }
  }
}

if(!function_exists('luxe_footer_template')) {
  /**
   * luxe Header Template
   * @since luxe 1.0
  */
  function luxe_footer_template($layout) {
    switch ($layout) {
      case 'default':
      default:
        get_template_part('theme/inc/footer/default');
        break;
    }
  }
}

if(!function_exists('luxe_title_wrapper_template')) {
  /**
   * luxe Title Wrapper Template
   * @since luxe 1.0
  */
  function luxe_title_wrapper_template($layout) {
    switch ($layout) {
      case 'default':
      default:
        get_template_part('theme/inc/title-wrapper/default');
        break;
    }
  }
}

if(!function_exists('luxe_blog_single_template')) {
  /**
   * luxe Blog Single Template
   * @since luxe 1.0
  */
  function luxe_blog_single_template($layout) {
    switch ($layout) {
      case 'default':
      default:
        get_template_part('theme/inc/blog-single/default');
        break;
    }
  }
}

if(!function_exists('luxe_fonts_url')) {
  /**
   * Load Google Font
   *
   * @param type $terms
   * @return boolean
   */
  function luxe_fonts_url() {
    $fonts_url = '';

    $open_sans       = _x( 'on', 'Open Sans font: on or off', 'luxe' );
    $old_standard_tt = _x( 'on', 'Old Standard TT font: on or off', 'luxe' );

    if ( 'off' !== $open_sans ) {
      $font_families = array();

      if ( 'off' !== $open_sans ) {
        $font_families[] = 'Open Sans:300,400,700';
      }

      if ( 'off' !== $old_standard_tt ) {
        $font_families[] = 'Old Standard TT:300,400,700';
      }

      $query_args = array('family' => urlencode( implode( '|', $font_families ) ), 'subset' => urlencode( 'latin,latin-ext' ));
      $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
  }
}

if(!function_exists('luxe_material_font_icon')) {
  /**
   * Load Material Icon
   *
   * @param type $terms
   * @return boolean
  */
  function luxe_material_font_icon() {
    $fonts_url = '';

    $material_icons = _x( 'on', 'Material Icons: on or off', 'luxe' );

    if ( 'off' !== $material_icons ) {
      $font_families = array();

      if ( 'off' !== $material_icons ) {
        $font_families[] = 'Material Icons';
      }

      $query_args = array('family' => urlencode( implode( '|', $font_families ) ));
      $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/icon' );
    }

    return esc_url_raw( $fonts_url );
  }
}

if ( ! function_exists( 'luxe_sanitize_html_classes' ) && function_exists( 'sanitize_html_class' ) ) {
  /**
  *
  * @return none
  * @param  class
  * multiple class sanitization
  *
  **/
  function luxe_sanitize_html_classes( $class, $fallback = null ) {

    if ( is_string( $class ) ) {
      $class = explode(" ", $class);
    }

    if ( is_array( $class ) && count( $class ) > 0 ) {
      $class = array_map("sanitize_html_class", $class);
      return implode(" ", $class);
    }
    else {
      return sanitize_html_class( $class, $fallback );
    }
  }
}

if ( ! function_exists( 'luxe_auto_post_excerpt' ) ) {
  /**
   *
   * Blog Excerpt Read More
   * @since 1.7.0
   * @version 1.0.0
   *
   */
  function luxe_auto_post_excerpt( $limit = '' ) {
    $limit   = ( empty($limit)) ? 20:$limit;
    $content = get_the_excerpt();
    $content = strip_shortcodes( $content );
    $content = str_replace( ']]>', ']]&gt;', $content );
    $content = strip_tags( $content );
    $words   = explode( ' ', $content, $limit + 1 );

    if( count( $words ) > $limit ) {

      array_pop( $words );
      $content  = implode( ' ', $words );
      $content .= ' &hellip;';

    }

    return $content;

  }
}

if ( ! function_exists( 'sanitize_html_classes' ) && function_exists( 'sanitize_html_class' ) ) {
  /**
  *
  * @return none
  * @param  class
  * multiple class sanitization
  *
  **/
  function sanitize_html_classes( $class, $fallback = null ) {

    // Explode it, if it's a string
    if ( is_string( $class ) ) {
      $class = explode(" ", $class);
    }

    if ( is_array( $class ) && count( $class ) > 0 ) {
      $class = array_map("sanitize_html_class", $class);
      return implode(" ", $class);
    }
    else {
      return sanitize_html_class( $class, $fallback );
    }
  }
}

if(!function_exists('luxe_get_custom_sidebars_list')) {
  /**
   * Get custom sidebars list
   * @return array
   */
  function luxe_get_custom_sidebars_list($add_default = true) {

    $sidebars = array();
    if ($add_default) {
      $sidebars['default'] = esc_html__('Default', 'luxe');
    }

    $options = get_option('bubble_theme_options');

    if (!isset($options['custom-sidebars']) || !is_array($options['custom-sidebars'])) {
      return $sidebars;
    }

    if (is_array($options['custom-sidebars'])) {
      foreach ($options['custom-sidebars'] as $sidebar) {
        $sidebars[sanitize_title ( $sidebar )] = $sidebar;
      }
    }

    return $sidebars;
  }
}

if( !function_exists('luxe_get_custom_sidebar')) {
  /**
   * Get custom sidebar, returns $default if custom sidebar is not defined
   * @param string $default
   * @param string $sidebar_option_field
   * @return string
   */
  function luxe_get_custom_sidebar($default = '', $sidebar_option_field = 'sidebar') {

    $sidebar = luxe_get_opt($sidebar_option_field);

    if ($sidebar != 'default' && !empty($sidebar)) {
      return $sidebar;
    }
    return $default;
  }
}

if(!function_exists('luxe_get_image_src')) {
  /**
   * Return URL
   * @param type $type
   * @return array
   */
  function luxe_get_image_src( $id, $image_size = 'full' ) {
    if(empty($id)) { return ; }
    $image_src = (is_numeric($id)) ? wp_get_attachment_image_src($id, $image_size):$id;
    return (is_array($image_src) && isset($image_src[0])) ? $image_src[0]:false;
  }
}

if(!function_exists('luxe_sidebar_position')) {
  /**
   * Return page layout
   * @param type $type
   * @return array
   */
  function luxe_sidebar_position() {
    $sidebar_details = array();
    if(is_singular('post')) {
      $sidebar_details['layout']       = luxe_get_opt('blog-single-layout');
      $sidebar_details['sidebar-name'] = 'blog-sidebar';
    } elseif(is_archive()) {
      $sidebar_details['layout']       = luxe_get_opt('archive-layout');
      $sidebar_details['sidebar-name'] = 'archive-sidebar';
    } elseif(luxe_is_room()) {
      $sidebar_details['layout']       = luxe_get_opt('room-single-layout');
      $sidebar_details['sidebar-name'] = 'single-room-sidebar';
    } elseif(luxe_is_search_result()) {
      $sidebar_details['layout']       = luxe_get_opt('search-result-layout');
      $sidebar_details['sidebar-name'] = 'search-result-sidebar';
    } else {
      $sidebar_details['layout'] = luxe_get_opt('main-layout');
      $sidebar_details['sidebar-name'] = 'sidebar';
    }
    return $sidebar_details;
  }
}

if(!function_exists('luxe_blog_post_column')) {
  /**
   * Return bol column class
   * @param type $type
   * @return array
   */
  function luxe_blog_post_column() {
    $sidebar_details = luxe_sidebar_position();
    $col_class = ($sidebar_details['layout'] != 'default' && !empty($sidebar_details['layout'])) ? 'col-md-6 col-xs-6 post__roll':'col-md-4 col-xs-6 post__roll';
    return $col_class;
  }
}

if(!function_exists('luxe_blog_post_grid_sizer')) {
  /**
   * Return bol column class
   * @param type $type
   * @return array
   */
  function luxe_blog_post_grid_sizer() {
    $sidebar_details = luxe_sidebar_position();
    $col_class = ($sidebar_details['layout'] != 'default' && !empty($sidebar_details['layout'])) ? '<div class="grid-sizer col-xs-12 col-sm-6 col-md-6"></div>':'<div class="grid-sizer col-xs-12 col-sm-6 col-md-4"></div>';
    return $col_class;
  }
}

if(!function_exists('luxe_translate')) {
  /**
   * Translate function
   * @param type $type
   * @return array
   */
  function luxe_translate($option_name, $default) {
    if(empty($option_name)) { return; }
    $to_be_translated = luxe_get_opt('translation-'.$option_name);
    $new_string = (!empty($to_be_translated)) ? $to_be_translated:$default;
    return $new_string;
  }
}
