<?php
/*
 * Top Header Section
*/
$this->sections[] = array(
  'title' => esc_html__('Top Header', 'luxe'),
  'desc' => esc_html__('Change the top header section configuration.', 'luxe'),
  'icon' => 'fa fa-columns',
  'fields' => array(
    array(
      'id'    => 'top-header-enable-switch',
      'type'  => 'switch',
      'title' => esc_html__('Enable Top Header', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default'  => '0',
      'subtitle' => esc_html__('If on, this layout part will be displayed.', 'luxe'),
    ),
    array(
      'id'   => 'random-number',
      'type' => 'info',
      'desc' => wp_kses_post('<h2 style="color:#0073aa;">Contact Information</h2>')
    ),
    array(
      'id'      => 'top-header-phone-number',
      'type'    => 'text',
      'title'   => esc_html__('Phone Number', 'luxe'),
      'default' => '1 877 834 3613',
    ),
    array(
      'id'      => 'top-header-location',
      'type'    => 'text',
      'title'   => esc_html__('Location', 'luxe'),
      'default' => '3655 S Las Vegas Blvd, Paris',
    ),
    array(
      'id'   => 'random-number',
      'type' => 'info',
      'desc' => wp_kses_post('<h2 style="color:#0073aa;">Social Icons</h2>')
    ),
    array(
      'id'       => 'top-header-social-icons-category',
      'type'     => 'select',
      'title'    => esc_html__('Social Icons Category', 'luxe'),
      'subtitle' => esc_html__('Select desired category', 'luxe'),
      'options'  => luxe_get_terms_assoc('social-site-category'),
      'default'  => '',
    ),

    array(
      'id' => 'random-number',
      'type' => 'info',
      'desc' => '<h3 style="color:#0073aa;">'.esc_html__('Top Header Color Settings', 'luxe').'</h3>'
    ),
    array(
      'id'      => 'customizer-top-header-bg-color',
      'type'    => 'color',
      'title'   => esc_html__('Top Header Background Color', 'luxe'),
      'default' => '',
      'output'  => array('background' => '.top-bar')
    ),
    array(
      'id'      => 'customizer-top-header-icon-color',
      'type'    => 'color',
      'title'   => esc_html__('Header Top Icon Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.top-bar i')
    ),
    array(
      'id'      => 'customizer-header-top-icon-color-hover',
      'type'    => 'color',
      'title'   => esc_html__('Top Header Icon Hover Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.top-bar i:hover')
    ),
    array(
      'id'      => 'customizer-top-header-text-color',
      'type'    => 'color',
      'title'   => esc_html__('Top Header Text Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.top-bar')
    ),
    array(
      'id'      => 'customizer-top-header-text-link-color',
      'type'    => 'color',
      'title'   => esc_html__('Top Header Text Link Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.top-bar a')
    ),
    array(
      'id'      => 'customizer-top-header-text-link-color-hover',
      'type'    => 'color',
      'title'   => esc_html__('TopHeader Text Link Hover Color', 'luxe'),
      'default' => '',
      'output'  => array('color' => '.top-bar a:hover')
    ),
  ), // #fields
);
