<?php
if (!class_exists('luxe_Redux_Framework_config')) {

    class luxe_Redux_Framework_config {

      public $args        = array();
      public $sections    = array();
      public $theme;
      public $ReduxFramework;

      public function __construct() {

        if (!class_exists('ReduxFramework')) {
          return;
        }

        if ( true == Redux_Helpers::isTheme( __FILE__ ) ) {
          $this->initSettings();
        } else {
          add_action('plugins_loaded', array($this, 'initSettings'), 10);
        }
      }

      public function initSettings() {

        $this->theme = wp_get_theme();
        $this->setArguments();
        $this->setSections();

        if (!isset($this->args['opt_name'])) { 
          return;
        }
        add_action( 'redux/loaded', array( $this, 'remove_demo' ) );
        $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
      }

      function dynamic_section($sections) {
        $sections[] = array(
            'title'  => esc_html__('Section via hook', 'luxe'),
            'desc'   => esc_html__('This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.', 'luxe'),
            'icon'   => 'el-icon-paper-clip',
            'fields' => array()
        );

        return $sections;
      }

      function change_arguments($args) {
        return $args;
      }

      function change_defaults($defaults) {
        $defaults['str_replace'] = 'Testing filter hook!';
        return $defaults;
      }
     
      function remove_demo() {
        if (class_exists('ReduxFrameworkPlugin')) {
          
        }
      }

      public function setSections() {

        $sample_patterns_path   = ReduxFramework::$_dir . '../sample/patterns/';
        $sample_patterns_url    = ReduxFramework::$_url . '../sample/patterns/';
        $sample_patterns        = array();

        if (is_dir($sample_patterns_path)) :

            if ($sample_patterns_dir = opendir($sample_patterns_path)) :
                $sample_patterns = array();

                while (( $sample_patterns_file = readdir($sample_patterns_dir) ) !== false) {

                    if (stristr($sample_patterns_file, '.png') !== false || stristr($sample_patterns_file, '.jpg') !== false) {
                        $name = explode('.', $sample_patterns_file);
                        $name = str_replace('.' . end($name), '', $sample_patterns_file);
                        $sample_patterns[]  = array('alt' => $name, 'img' => $sample_patterns_url . $sample_patterns_file);
                    }
                }
            endif;
        endif;

        ob_start();

        $ct          = wp_get_theme();
        $this->theme = $ct;
        $item_name   = $this->theme->get('Name');
        $tags        = $this->theme->Tags;
        $screenshot  = $this->theme->get_screenshot();
        $class       = $screenshot ? 'has-screenshot' : '';
        $customize_title = sprintf(esc_html__('Customize &#8220;%s&#8221;', 'luxe'), $this->theme->display('Name')); ?>
        <div id="current-theme" class="<?php echo esc_attr($class); ?>">
        <?php if ($screenshot) : ?>
          <?php if (current_user_can('edit_theme_options')) : ?>
            <a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr($customize_title); ?>">
                <img src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview', 'luxe'); ?>" />
            </a>
          <?php endif; ?>
            <img class="hide-if-customize" src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview', 'luxe'); ?>" />
          <?php endif; ?>

            <h4><?php echo esc_html($this->theme->display('Name')); ?></h4>
            <div>
              <ul class="theme-info">
                <li><?php printf(esc_html__('By %s', 'luxe'), $this->theme->display('Author')); ?></li>
                <li><?php printf(esc_html__('Version %s', 'luxe'), $this->theme->display('Version')); ?></li>
                <li><?php echo '<strong>' . esc_html__('Tags', 'luxe') . ':</strong> '; ?><?php printf($this->theme->display('Tags')); ?></li>
              </ul>
              <p class="theme-description"><?php echo esc_html($this->theme->display('Description')); ?></p>
                <?php if ($this->theme->parent()):
                  printf(' <p class="howto">' . wp_kses_data(__('This <a href="%1$s">child theme</a> requires its parent theme, %2$s.', 'luxe')) . '</p>', esc_html__('http://codex.wordpress.org/Child_Themes', 'luxe'), $this->theme->parent()->display('Name'));
                endif; ?>

            </div>
          </div>

          <?php
          $item_info = ob_get_contents();

          ob_end_clean();

          $sampleHTML = '';
          if (file_exists(get_template_directory() . '/admin/info-html.html')) {
            global $wp_filesystem;
            if (empty($wp_filesystem)) {
              require_once(ABSPATH . '/wp-admin/includes/file.php');
              WP_Filesystem();
            }
            $sampleHTML = $wp_filesystem->get_contents(get_template_directory() . '/admin/info-html.html');
          }

          require get_template_directory() . '/admin/options/general.php';
          require get_template_directory() . '/admin/options/top-header.php';
          require get_template_directory() . '/admin/options/header.php';
          require get_template_directory() . '/admin/options/menu.php';
          require get_template_directory() . '/admin/options/title-wrapper.php';
          require get_template_directory() . '/admin/options/blog-single.php';
          require get_template_directory() . '/admin/options/archive.php';
          require get_template_directory() . '/admin/options/hotel-booking.php';
          require get_template_directory() . '/admin/options/favicon.php';
          require get_template_directory() . '/admin/options/typography.php';
          require get_template_directory() . '/admin/options/footer.php';
          require get_template_directory() . '/admin/options/google-map.php';
          require get_template_directory() . '/admin/options/translation.php';
          $is_valid = (defined('ENVATO_HOSTED_SITE')) ? true:get_option('is_valid');
          if($is_valid == true && function_exists('redux_register_custom_extension_loader_demo')):
            require get_template_directory() . '/admin/options/demo-import.php';
          endif;
          require get_template_directory() . '/admin/options/export.php';

          $theme_info  = '<div class="redux-framework-section-desc">';
          $theme_info .= '<p class="redux-framework-theme-data description theme-uri">' . esc_html__('<strong>Theme URL:</strong> ', 'luxe') . '<a href="' . $this->theme->get('ThemeURI') . '" target="_blank">' . $this->theme->get('ThemeURI') . '</a></p>';
          $theme_info .= '<p class="redux-framework-theme-data description theme-author">' . esc_html__('<strong>Author:</strong> ', 'luxe') . $this->theme->get('Author') . '</p>';
          $theme_info .= '<p class="redux-framework-theme-data description theme-version">' . esc_html__('<strong>Version:</strong> ', 'luxe') . $this->theme->get('Version') . '</p>';
          $theme_info .= '<p class="redux-framework-theme-data description theme-description">' . $this->theme->get('Description') . '</p>';
          $tabs = $this->theme->get('Tags');
          if (!empty($tabs)) {
              $theme_info .= '<p class="redux-framework-theme-data description theme-tags">' . esc_html__('<strong>Tags:</strong> ', 'luxe') . implode(', ', $tabs) . '</p>';
          }
          $theme_info .= '</div>';

          $this->sections[] = array(
              'type' => 'divide',
          );


          if (file_exists(get_template_directory() . '/README.html')) {
            $tabs['docs'] = array(
              'icon'      => 'el-icon-book',
              'title'     => esc_html__('Documentation', 'luxe'),
              'content'   => nl2br(luxe_read_file(get_template_directory(),'README.html'))
            );
          }
      }

      public function setHelpTabs() {

          $this->args['help_tabs'][] = array(
            'id'        => 'redux-help-tab-1',
            'title'     => esc_html__('Theme Information 1', 'luxe'),
            'content'   => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'luxe')
          );

          $this->args['help_tabs'][] = array(
            'id'        => 'redux-help-tab-2',
            'title'     => esc_html__('Theme Information 2', 'luxe'),
            'content'   => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'luxe')
          );

          $this->args['help_sidebar'] = esc_html__('<p>This is the sidebar content, HTML is allowed.</p>', 'luxe');
      }

      public function setArguments() {

          $theme = wp_get_theme(); // For use with some settings. Not necessary.

          $this->args = array(
                'opt_name'              => REDUX_OPT_NAME,
                'dev_mode'              => false,
                'page_slug' => 'rs_theme_options',
                'page_title' => 'Options',
                'page_parent' => 'rs_theme_welcome',
                'update_notice'         => true,
                'intro_text'            => '<p>Theme Options Panel</p>',
                'footer_text'           => '<p></p>',
                'admin_bar'             => true,
                'show_options_object'   => false,
                'menu_type'             => 'submenu',
                'menu_title'            => 'Theme Options',
                'allow_sub_menu'        => true,
                'page_parent_post_type' => 'your_post_type',
                'customizer'            => true,
                'default_mark'          => '*',
              'hints' =>
              array(
                'icon' => 'el-icon-question-sign',
                'icon_position' => 'right',
                'icon_size' => 'normal',
                'tip_style' =>
                array(
                  'color' => 'light',
                ),
                'tip_position' =>
                array(
                  'my' => 'top left',
                  'at' => 'bottom right',
                ),
                'tip_effect' =>
                array(
                  'show' =>
                  array(
                    'duration' => '500',
                    'event' => 'mouseover',
                  ),
                  'hide' =>
                  array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                  ),
                ),
              ),
              'output' => true,
              'output_tag' => true,
              'compiler' => true,
              'page_icon' => 'icon-themes',
              'page_permissions' => 'manage_options',
              'save_defaults' => true,
              'show_import_export' => false,
              'transient_time' => '3600',
              'network_sites' => true,
            );

          $theme = wp_get_theme(); // For use with some settings. Not necessary.
          $this->args["display_name"] = $theme->get("Name");
          $this->args["display_version"] = $theme->get("Version");
        }

    }

    global $reduxConfig;
    $reduxConfig = new luxe_Redux_Framework_config();
}

function luxe_remove_redux_menu() {
  remove_submenu_page('tools.php','redux-about');
}
add_action( 'admin_menu', 'luxe_remove_redux_menu',12 );
