<?php
/**
 * WP Hotel Booking
 */

$this->sections[] = array(
  'title' => esc_html__('WP Hotel Booking', 'luxe'),
  'icon' => 'fa fa-calendar',
  'fields' => array(
  ), // #fields
);
$this->sections[] = array(
  'title' => esc_html__('Search Page', 'luxe'),
  'desc' => esc_html__('Configure heading styles.', 'luxe'),
  'subsection' => true,
  'fields' => array(
    array(
      'id'        => 'search-result-layout',
      'type'      => 'select',
      'compiler'  => true,
      'title'     => esc_html__('Layout', 'luxe'),
      'subtitle'  => esc_html__('Select sidebar alignment. Choose between 1 or 2 column layout.', 'luxe'),
      'options'   => array(
        'default'       => esc_html__('1 Column', 'luxe'),
        'left_sidebar'  => esc_html__('2 - Columns Left', 'luxe'),
        'right_sidebar' => esc_html__('2 - Columns Right', 'luxe'),
      ),
      'default'   => 'default',
    ),
    array(
      'id'        => 'search-result-sidebar',
      'type'      => 'select',
      'title'     => esc_html__('Sidebar', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('search-result-layout', 'equals', array('left_sidebar', 'right_sidebar')),
    ),
    array(
      'id' => 'search-result-desc',
      'type'   => 'switch',
      'title' => esc_html__('Description', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'search-result-capacity',
      'type'   => 'switch',
      'title' => esc_html__('Capacity', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'search-result-children',
      'type'   => 'switch',
      'title' => esc_html__('Children', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'search-result-animities',
      'type'   => 'switch',
      'title' => esc_html__('Animites', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
  ),
);

$this->sections[] = array(
  'title' => esc_html__('Single Page', 'luxe'),
  'desc' => esc_html__('Configure room single page.', 'luxe'),
  'subsection' => true,
  'fields' => array(
    array(
      'id'        => 'room-single-layout',
      'type'      => 'select',
      'compiler'  => true,
      'title'     => esc_html__('Layout', 'luxe'),
      'subtitle'  => esc_html__('Select sidebar alignment. Choose between 1 or 2 column layout.', 'luxe'),
      'options'   => array(
        'default'       => esc_html__('1 Column', 'luxe'),
        'left_sidebar'  => esc_html__('2 - Columns Left', 'luxe'),
        'right_sidebar' => esc_html__('2 - Columns Right', 'luxe'),
      ),
      'default'   => 'default',
    ),
    array(
      'id'        => 'single-room-sidebar',
      'type'      => 'select',
      'title'     => esc_html__('Sidebar', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('room-single-layout', 'equals', array('left_sidebar', 'right_sidebar')),
    ),
    array(
      'id' => 'single-room-desc',
      'type'   => 'switch',
      'title' => esc_html__('Description', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'single-room-gallery',
      'type'   => 'switch',
      'title' => esc_html__('Gallery', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'single-room-review',
      'type'   => 'switch',
      'title' => esc_html__('Review', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
  ),
);

$this->sections[] = array(
  'title' => esc_html__('Checkout Page', 'luxe'),
  'desc' => esc_html__('Configure body styles.', 'luxe'),
  'subsection' => true,
  'fields' => array(
    array(
      'id' => 'font-body',
      'type' => 'typography',
      'title' => esc_html__('Body', 'luxe'),
      'font-size'=> true,
      'line-height'=> true,
      'text-align' => false,
      'color' => false,
      'output' => array('body, .tt-slider-content .tt-subtitle'),
    ),
  ),
);


$this->sections[] = array(
  'title' => esc_html__('Cart Page', 'luxe'),
  'desc' => esc_html__('Configure body styles.', 'luxe'),
  'subsection' => true,
  'fields' => array(
    array(
      'id' => 'font-body',
      'type' => 'typography',
      'title' => esc_html__('Body', 'luxe'),
      'font-size'=> true,
      'line-height'=> true,
      'text-align' => false,
      'color' => false,
      'output' => array('body, .tt-slider-content .tt-subtitle'),
    ),
  ),
);
