<?php
/*
 * General Section
*/
$this->sections[] = array(
  'title' => esc_html__('General', 'luxe'),
  'desc' => esc_html__('Configure general styles.', 'luxe'),
  'icon' => 'fa fa-toggle-on',
  'subsection' => true,
  'fields'  => array(
    array(
      'id'        => 'theme-skin',
      'type'      => 'select',
      'compiler'  => true,
      'title'     => esc_html__('Theme Skin', 'luxe'),
      'subtitle'  => esc_html__('Select theme skin color.', 'luxe'),
      'options'   => array(
        'theme-default' => esc_html__('Default', 'luxe'),
        'theme-accent'  => esc_html__('Accent', 'luxe'),
      ),
      'default'   => 'theme-default',
    ),
    array(
      'id'        => 'theme-skin-accent',
      'type'      => 'color',
      'title'     => esc_html__('Accent Color', 'luxe'),
      'desc'     => esc_html__( 'This color is main color.', 'luxe' ),
      'default'   => '',
      'required'  => array('theme-skin', 'equals', array('theme-accent')),
    ),
    array(
      'id'       => 'page-layout',
      'type'     => 'image_select',
      'width'    => '180',
      'title'    => esc_html__('Layout', 'luxe'),
      'options'  => array(
        'full-width'  => array(
          'alt' => 'Full Width',
          'img' => get_theme_file_uri('admin/assets/img/panel/6.png')
        ),
        'boxed'  => array(
          'alt' => 'Boxed',
          'img' => get_theme_file_uri('admin/assets/img/panel/5.png')
        ),
      ),
      'default' => 'full-width',
      'validate' => '',
    ),
    array(
      'id' => 'general-loader-enable-switch',
      'type' => 'switch',
      'title' => esc_html__('Enable Loader', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
      'subtitle' => esc_html__('If on, this layout part will be displayed.', 'luxe'),
    ),
    array(
      'id' => 'page-top-margin',
      'type' => 'switch',
      'title' => esc_html__('Top Margin', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
      'subtitle' => esc_html__('If on, space will be added after header.', 'luxe'),
    ),
    array(
      'id' => 'page-bottom-margin',
      'type' => 'switch',
      'title' => esc_html__('Bottom Margin', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
      'subtitle' => esc_html__('If on, space will be added before footer.', 'luxe'),
    ),
    array(
      'id'        => 'main-layout',
      'type'      => 'select',
      'compiler'  => true,
      'title'     => esc_html__('Main Layout', 'luxe'),
      'subtitle'  => esc_html__('Select main content and sidebar alignment. Choose between 1 or 2 column layout.', 'luxe'),
      'options'   => array(
        'default'       => esc_html__('1 Column', 'luxe'),
        'left_sidebar'  => esc_html__('2 - Columns Left', 'luxe'),
        'right_sidebar' => esc_html__('2 - Columns Right', 'luxe'),
      ),
      'default'   => 'default',
    ),
    array(
      'id'        => 'sidebar',
      'type'      => 'select',
      'title'     => esc_html__('Sidebar', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('main-layout', 'equals', array('left_sidebar', 'right_sidebar')),
    ),
    array(
      'id'       => 'custom-sidebars',
      'type'     => 'multi_text',
      'title'    => esc_html__( 'Custom Sidebars', 'luxe' ),
      'subtitle' => esc_html__( 'Custom sidebars can be assigned to any page or post.', 'luxe' ),
      'desc'     => esc_html__( 'You can add as many custom sidebars as you need.', 'luxe' )
    ),
  ),
);



