<?php
/*
 * Advanced
*/
$this->sections[] = array(
  'title' => esc_html__('Archive Page', 'luxe'),
  'desc' => esc_html__('Arichive page confugration.', 'luxe'),
  'icon'  => 'fa fa-file-archive-o',
  'fields' => array(
    array(
      'id'        => 'archive-layout',
      'type'      => 'select',
      'compiler'  => true,
      'title'     => esc_html__('Layout', 'luxe'),
      'subtitle'  => esc_html__('Select sidebar alignment. Choose between 1 or 2 column layout.', 'luxe'),
      'options'   => array(
        'default'       => esc_html__('1 Column', 'luxe'),
        'left_sidebar'  => esc_html__('2 - Columns Left', 'luxe'),
        'right_sidebar' => esc_html__('2 - Columns Right', 'luxe'),
      ),
      'default'   => 'default',
    ),
    array(
      'id'        => 'archive-sidebar',
      'type'      => 'select',
      'title'     => esc_html__('Sidebar', 'luxe'),
      'subtitle'  => esc_html__('Select custom sidebar', 'luxe'),
      'options'   => luxe_get_custom_sidebars_list(),
      'default'   => '',
      'required'  => array('archive-layout', 'equals', array('left_sidebar', 'right_sidebar')),
    ),
    array(
      'id' => 'archive-page-excerpt',
      'type'   => 'text',
      'title' => esc_html__('Excerpt Length', 'luxe'),
      'subtitle'=> esc_html__('Add excerpt length.', 'luxe'),
      'default' => 30,
    ),
    array(
      'id' => 'archive-page-author',
      'type'   => 'switch',
      'title' => esc_html__('Author', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'archive-page-category',
      'type'   => 'switch',
      'title' => esc_html__('Category', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),
    array(
      'id' => 'archive-page-read-more',
      'type'   => 'switch',
      'title' => esc_html__('Read More', 'luxe'),
      'subtitle'=> esc_html__('If on, this layout part will be displayed.', 'luxe'),
      'options' => array(
        '1' => 'On',
        '0' => 'Off',
      ),
      'default' => '1',
    ),

  ), // #fields
);
