<?php
$redux_opt_name = REDUX_OPT_NAME;
if(!function_exists('luxe_redux_add_metaboxes')) {
  function luxe_redux_add_metaboxes($metaboxes) {

    $metaboxes = array();

    $metaboxes[] = luxe_redux_get_post_opt_metaboxes();
    $metaboxes[] = luxe_redux_get_page_template_blog_metaboxes();
    $metaboxes[] = luxe_redux_get_page_metaboxes();
    $metaboxes[] = luxe_redux_get_audio_post_metaboxes();
    $metaboxes[] = luxe_redux_get_gallery_post_metaboxes();
    $metaboxes[] = luxe_redux_get_post_adv_metaboxes();
    $metaboxes[] = luxe_redux_get_social_metaboxes();
    $metaboxes[] = luxe_redux_get_testimonial_metaboxes();

    return $metaboxes;
  }
  add_action('redux/metaboxes/'.$redux_opt_name.'/boxes', 'luxe_redux_add_metaboxes');
}

if(!function_exists('luxe_redux_get_page_template_blog_metaboxes')) {
  /**
   * Get configuration array for blog template
   * @return type
  */
  function luxe_redux_get_page_template_blog_metaboxes() {
    $sections = array();
    require get_template_directory() . '/admin/metaboxes/page-template-blog.php';
    return array(
      'id'         => 'luxe-template-blog-options',
      'title'      => esc_html__('Blog Options', 'luxe'),
      'post_types' => array('page'),
      'position'   => 'normal', 
      'priority'   => 'high', 
      'sections'   => $sections,
      'page_template' => array(
        'tpl-blog-list.php',
      )
    );
  }
}

/**
 * Get configuration array for contact template
 * @return type
 */
function luxe_redux_get_social_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/admin/metaboxes/social-site.php';

  return array(
    'id' => 'luxe-template-social-options',
    'title' => esc_html__('Social Options', 'luxe'),
    'post_types' => array('social-site'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
  );
}


/**
 * Get configuration array for page metaboxes
 * @return type
 */
function luxe_redux_get_page_metaboxes() {

  $sections = array();

  require get_template_directory() . '/admin/metaboxes/title-wrapper.php';
  require get_template_directory() . '/admin/metaboxes/content.php';
  require get_template_directory() . '/admin/metaboxes/sidebar.php';

  return array(
    'id' => 'luxe-page-options',
    'title' => esc_html__('Options', 'luxe'),
    'post_types' => array('page'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections
  );
}

/**
 * Get configuration array for video post metaboxes
 * @return type
 */
function luxe_redux_get_audio_post_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/admin/metaboxes/post-audio.php';

  return array(
    'id' => 'luxe-audio-post-options',
    'title' => esc_html__('Audio Post Options', 'luxe'),
    'post_types' => array('post'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
    'post_format' => array('audio')
  );
}

/**
 * Get configuration array for gallery post metaboxes
 * @return type
 */
function luxe_redux_get_gallery_post_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/admin/metaboxes/post-gallery.php';

  return array(
    'id' => 'luxe-gallery-post-options',
    'title' => esc_html__('Gallery Post Options', 'luxe'),
    'post_types' => array('post'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections,
    'post_format' => array('gallery')
  );
}

/**
 * Get configuration array for gallery post metaboxes
 * @return type
 */
function luxe_redux_get_post_opt_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/admin/metaboxes/post-sidebar.php';

  return array(
    'id' => 'luxe-post-sidebar-options',
    'title' => esc_html__('Layout', 'luxe'),
    'post_types' => array('post'),
    'position' => 'side', // normal, advanced, side
    'priority' => 'default', // high, core, default, low
    'sections' => $sections,
  );
}

/**
 * Get configuration array for page metaboxes
 * @return type
 */
function luxe_redux_get_post_adv_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/admin/metaboxes/title-wrapper.php';

  return array(
    'id' => 'luxe-post-adv-options',
    'title' => esc_html__('Options', 'luxe'),
    'post_types' => array('post'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections
  );
}

/**
 * Get configuration array for testimonial metaboxes
 * @return type
 */
function luxe_redux_get_testimonial_metaboxes() {

  // Variable used to store the configuration array of sections
  $sections = array();

  // Metabox used to overwrite theme options by page
  require get_template_directory() . '/admin/metaboxes/testimonial.php';

  return array(
    'id' => 'luxe-testimonial-options',
    'title' => esc_html__('Testimonial', 'luxe'),
    'post_types' => array('testimonial'),
    'position' => 'normal', // normal, advanced, side
    'priority' => 'high', // high, core, default, low
    'sections' => $sections
  );
}


