<?php
/**
 * Admin Action Hooks.
 *
 * @package luxe
 * @since 1.0
*/
if(!function_exists('luxe_admin_enqueue_scripts')) {
  function luxe_admin_enqueue_scripts() {
    wp_enqueue_style('admin-custom',  get_theme_file_uri('admin/assets/css/admin.css'), '1.0');
  }
  add_action( 'admin_enqueue_scripts', 'luxe_admin_enqueue_scripts' );
}

if(!function_exists('luxe_redux_custom_enqueue_scripts')) {
  function luxe_redux_custom_enqueue_scripts() {
    wp_deregister_style( 'redux-elusive-icon' );
    wp_deregister_style( 'redux-elusive-icon-ie7' );
    wp_enqueue_style('redux-custom',           get_theme_file_uri('admin/assets/css/redux-custom.css'), array('redux-admin-css'), '1.0');
    wp_enqueue_style('font-awesome-admin',     get_theme_file_uri('assets/css/font-awesome.min.css'),null, '1.0');
  }
  add_action( 'redux/page/bubble_theme_options/enqueue', 'luxe_redux_custom_enqueue_scripts' );
}
