<?php
/**
 * Admin Helpers Functions
 *
 * @package luxe
 * @since 1.0
*/
if(!function_exists('luxe_get_opt')) {
  /**
   * Get theme option value
   * @param string $option
   * @return mix|boolean
  */
  function luxe_get_opt($option) {
    global $bubble_theme_options;

    $local = false;

    if (class_exists( 'WooCommerce' ) && (is_shop() || is_product_category() || is_product_tag())) {

      $shop_page = wc_get_page_id( 'shop' );

      if (!empty($shop_page)) {
        $value = luxe_get_post_opt( $option.'-local', (int)$shop_page);
        $local = true;
      }

    } else if (is_singular()) {
      $value = luxe_get_post_opt( $option.'-local' );
      $local = true;
    }

    if ($local === true) {
      $first_element = null;
      if (is_array($value)) {
        $first_element = reset($value);
      }
      if (is_string($value) && (strlen($value) > 0 || !empty($value)) || is_array($value) && !empty($first_element)) {
        return $value;
      }
    }

    if (isset($bubble_theme_options[$option])) {
      return $bubble_theme_options[$option];
    }
    return false;
  }
}

if(!function_exists('luxe_get_post_opt')) {
  /**
   * Get single post option value
   * @param unknown $option
   * @param string $id
   * @return NULL|mixed
  */
  function luxe_get_post_opt( $option, $id = '' ) {

    global $post;

    if (!empty($id)) {
      $local_id = $id;
    } else {
      if(!isset($post->ID)) {
        return null;
      }
      $local_id = get_the_ID();
    }
    
    if(function_exists('redux_post_meta')) {
      $options = redux_post_meta(REDUX_OPT_NAME, $local_id);
    } else {
      $options = get_post_meta( $local_id, REDUX_OPT_NAME, true );
    }

    if( isset( $options[$option] ) ) {
      return $options[$option];
    } else {
      return null;
    }
  }
}

if(!function_exists('luxe_get_custom_sidebars_list')) {
  /**
   * Get custom sidebars list
   * @return array
  */
  function luxe_get_custom_sidebars_list($add_default = true) {

    $sidebars = array();
    if ($add_default) {
      $sidebars['default'] = esc_html__('Default', 'luxe');
    }

    $options = get_option('bubble_theme_options');

    if (!isset($options['custom-sidebars']) || !is_array($options['custom-sidebars'])) {
      return $sidebars;
    }

    if (is_array($options['custom-sidebars'])) {
      foreach ($options['custom-sidebars'] as $sidebar) {
        $sidebars[sanitize_title ( $sidebar )] = $sidebar;
      }
    }

    return $sidebars;
  }  
}

if( !function_exists('luxe_get_custom_sidebar')) {

  /**
   * Get custom sidebar, returns $default if custom sidebar is not defined
   * @param string $default
   * @param string $sidebar_option_field
   * @return string
  */
  function luxe_get_custom_sidebar($default = '', $sidebar_option_field = 'sidebar') {

    $sidebar = luxe_get_opt($sidebar_option_field);

    if ($sidebar != 'default' && !empty($sidebar)) {
      return $sidebar;
    }
    return $default;
  }
}

if(!function_exists('luxe_get_terms_assoc')) {
  /**
   * Get associative terms array
   *
   * @param type $terms
   * @return boolean
  */
  function luxe_get_terms_assoc($terms) {
    $terms = get_terms( $terms , array('fields' => 'all' ) );

    if (is_array($terms) && !is_wp_error($terms)) {
      $terms_assoc = array();

      foreach ($terms as $term) {
        $terms_assoc[$term ->term_id] = $term ->name;
      }
      return $terms_assoc;
    }
    return false;
  }
}

if ( ! function_exists( 'luxe_element_values_page' ) ) {
  /**
   *
   * element values post, page, categories
   * @since 1.0.0
   * @version 1.0.0
   *
   */
  function luxe_element_values_page(  $type = '', $query_args = array() ) {

    $options = array();

    switch( $type ) {

      case 'pages':
      case 'page':
      $pages = get_pages( $query_args );

      if ( !empty($pages) ) {
        foreach ( $pages as $page ) {
          $options[$page->post_title] = $page->ID;
        }
      }
      break;

      case 'posts':
      case 'post':
      $posts = get_posts( $query_args );

      if ( !empty($posts) ) {
        foreach ( $posts as $post ) {
          $options[$post->post_title] = lcfirst($post->post_title);
        }
      }
      break;

      case 'tags':
      case 'tag':

      $tags = get_terms( $query_args['taxonomies'], $query_args['args'] );
        if ( !empty($tags) ) {
          foreach ( $tags as $tag ) {
            $options[$tag->term_id] = $tag->name;
        }
      }
      break;

      case 'categories':
      case 'category':

      $categories = get_categories( $query_args );
      if ( !empty($categories) ) {
        foreach ( $categories as $category ) {
          $options[$category->term_id] = $category->name;
        }
      }
      break;

      case 'custom':
      case 'callback':

      if( is_callable( $query_args['function'] ) ) {
        $options = call_user_func( $query_args['function'], $query_args['args'] );
      }

      break;

    }

    return $options;

  }
}

if(!function_exists('luxe_return_bytes')) {
  /**
   * return size in bytes
   * @param string $magplus_return_bytes
   * @param string $magplus_return_bytes
   * @return integer
  */
  function luxe_return_bytes($size) {
    $val   = substr( $size, -1 );
    $ret = substr( $size, 0, -1 );
    switch ( strtoupper( $val ) ) {
      case 'P':
       $ret *= 1024;
      case 'T':
       $ret *= 1024;
      case 'G':
       $ret *= 1024;
      case 'M':
       $ret *= 1024;
      case 'K':
       $ret *= 1024;
    }
    return $ret;
  }
}

if( ! function_exists( 'luxe_envato_verify_purchase' ) ) {
  /**
   *
   * Envato Verify Purchase by Purchase Code
   *
   */
  function luxe_envato_verify_purchase( $purchase_code ) {
    $response = wp_remote_get( 'http://www.themebubble.com/verify/verify.php?code='. $purchase_code );
    if ( is_array( $response ) ) {
      $body = $response['body'];
      $attr = json_decode($body);
      $is_valid = ($attr->item_id == '21551733') ? true:false;
      return $is_valid;
    }
  }
}