<?php
/**
 * 404
 *
 * @package luxe
 * @since 1.0
 */

get_header(); ?>

<section class="v-align">
  <div class="marg-lg-b75 marg-xs-b25"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-md-offset-3">
        <div class="page-404__content text-center">
          <h1><?php echo luxe_translate('404','404'); ?></h1>
          <p><?php echo esc_html__('The page you are looking for does not exist. It may have been moved, or removed altogether. Perhaps you can return back to the site’s homepage and see if you can find what you are looking for.', 'luxe'); ?></p>
          <a class="btn" target="_self" title="<?php echo esc_attr__('button', 'luxe'); ?>" href="<?php echo esc_url(home_url('/')); ?>"><?php echo luxe_translate('back-to-home', 'Back to Home'); ?></a>
        </div><!-- /page-404-content -->
      </div><!-- /col-md-12 -->
    </div><!-- /row -->
  </div><!-- /container -->
  <div class="marg-lg-b100 marg-xs-b50"></div>
</section>

<?php
get_footer();
