<?php
/**
 *
 * RS Video Banner
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_video_banner( $atts, $content = '', $id = '' ) {
  extract( shortcode_atts( array(
    'id'                  => '',
    'class'               => '',
    'small_heading'       => '',
    'big_heading'         => '',
    'video_url'           => '',
    'overlay'             => 'no',
    'bg_image'            => '',
    'big_heading_color'   => '',
    'small_heading_color' => '',
  ), $atts ) );

  $id                  = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class               = ( $class ) ? ' '. sanitize_html_classes($class) : '';
  $big_heading_color   = ($big_heading_color) ? ' style="color:'.esc_attr($big_heading_color).';"':'';
  $small_heading_color = ($small_heading_color) ? ' style="color:'.esc_attr($small_heading_color).';"':'';
  $image_src           = rs_get_image_src($bg_image);
  $overlay_class       = ($overlay == 'yes') ? ' has-overlay':'';

  if(!empty($image_src)) {
    $data_image  = ' data-image="'.esc_url($image_src).'"';
    //$style_attr = ' style="background-image:url('.esc_url($image_src).'"';
  }

  $output  = '<div '.$id.' class="jumbotron'.sanitize_html_classes($overlay_class).' jumbotron--lg'.$class.'" '.$data_image.'>';
  $output .=  '<div class="row">';
  $output .=  '<div class="col-md-12 jumbotron-text__content">';
  if(!empty($video_url)):
    $output .=  '<a class="hb-video__anchor" data-video="'.esc_url($video_url).'?autoplay=1"><i 
  class="icon-single fa fa-youtube-play"></i></a>';
    $output .=  '<div class="hb-video__popup">';
    $output .=  '<div class="hb-video__caption"></div>';
    $output .=  '<div class="hb-video__table">';
    $output .=  '<div class="hb-video__cell">';
    $output .=  '<div class="embed-responsive embed-responsive-16by9">';
    $output .=  '<iframe class="embed-responsive-item" src="about:blank"></iframe>';
    $output .=  '<div class="hb-video__close"></div>';
    $output .=  '</div>';
    $output .=  '</div>';
    $output .=  '</div>';
    $output .=  '</div>';
  endif;
  $output .=  '<div class="spacing" style="height: 30px"></div>';
  $output .=  '<div class="subtitle subtitle--lg"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
  $output .=  '<div class="title title--lg"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
  $output .=  '</div>';
  $output .=  '</div>';
  $output .=  '</div>';
      
  return $output;
}

add_shortcode('rs_video_banner', 'rs_video_banner');
