<?php
/**
 *
 * RS Image Block
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_text_block_with_signature( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'            => '',
    'class'         => '',
    'signature'     => '',
    'small_heading' => '',
    'big_heading'   => '',
  ), $atts ) );

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';

  $output = '';
  $signature = rs_get_image_src($signature);

  $output  =  '<div '.$id.' class="text-block__signature'.$class.'">';
  $output .=  '<div class="subtitle subtitle--left subtitle--sm">'.wp_kses_post($small_heading).'</div>';
  $output .=  '<div class="title title--left title-color-black title--sm"><h2>'.wp_kses_post($big_heading).'</h2></div>';
  $output .=  '<div class="spacing" style="height: 4px"></div>';
  $output .=  '<div class="text">';
  $output .=  '<p>'.wp_kses_post($content).'</p>';
  $output .=  '</div>';
  $output .=  '<div class="spacing" style="height: 15px"></div>';
  if(!empty($signature)) {
    $output .=  '<img src="'.esc_url($signature).'" alt="Signature">';
  }
  $output .=  '</div>';

  return $output;
}

add_shortcode('rs_text_block_with_signature', 'rs_text_block_with_signature');
