<?php
/**
 *
 * Testimonial
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_testimonial( $atts, $content = '', $id = '' ) {
  extract( shortcode_atts( array(
    'id'    => '',
    'class' => '',
    'cats'  => '',
    'limit' => '3',
  ), $atts ) );

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' '. $class : '';

  $args = array(
    'post_type'      => 'testimonial',
    'posts_per_page' => $limit,
  );

  if( $cats ) {
    $args['tax_query'] = array(
      array(
        'taxonomy' => 'testimonial-category',
        'field'    => 'slug',
        'terms'    => explode( ',', $cats )
      )
    );
  }

  $the_query = new WP_Query( $args );

  ob_start();  ?>

  <div <?php echo esc_attr($id); ?> class="testimonial__wrapper<?php echo esc_attr($class); ?>">
    <div class="row">
      <?php 
        while( $the_query->have_posts()) : $the_query->the_post(); 
        $company_logo = luxe_get_post_opt('testimonial-company-logo');
        $image_src    = rs_get_image_src(get_post_thumbnail_id(get_the_ID()));
      ?>
      <div class="col-sm-4">
        <div class="testimonial mb-0 mt-0">
          <?php if(!empty($image_src)): ?>
            <img class="testimonial__avatar" src="<?php echo esc_url($image_src); ?>" alt="">
          <?php endif; ?>
          <div class="testimonial__name"><?php the_title(); ?></div>
          <div class="testimonial__text"><?php the_content(); ?></div>
          <?php if(!empty($company_logo) && is_array($company_logo)): ?>
            <img class="testimonial__logo" src="<?php echo esc_url($company_logo['url']); ?>" alt="">
          <?php endif; ?>
        </div>
        <div class="empty-space  marg-xs-b5"></div>
      </div>
      <?php endwhile; wp_reset_postdata(); ?>
    </div>
  </div>

  <?php

  $output = ob_get_clean();

  return $output;

}
add_shortcode( 'rs_testimonial', 'rs_testimonial');
