<?php
/**
 *
 * RS Space
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_section_heading( $atts, $content = '', $id = '' ) {

  extract( shortcode_atts( array(
    'id'                      => '',
    'class'                   => '',
    'small_heading'           => '',
    'big_heading'             => '',
    'big_heading_color'       => '',
    'big_heading_font_size'   => '',
    'small_heading_color'     => '',
    'small_heading_font_size' => '',
  ), $atts ) );

  $id    = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';

  $big_heading_color_attr   = ($big_heading_color) ? 'color:'.esc_attr($big_heading_color).';':'';
  $big_heading_font_attr    = ($big_heading_font_size) ? 'font-size:'.esc_attr($big_heading_font_size).';':'';
  $small_heading_color_attr = ($small_heading_color) ? 'color:'.esc_attr($small_heading_color).';':'';
  $small_heading_font_attr  = ($small_heading_font_size) ? 'font-size:'.esc_attr($small_heading_font_size).';':'';
  $big_heading_style        = ($big_heading_color || $big_heading_font_size) ? ' style="'.$big_heading_font_attr.$big_heading_color_attr.'"':'';
  $small_heading_style      = ($small_heading_color || $small_heading_font_size) ? ' style="'.$small_heading_font_attr.$small_heading_color_attr.'"':'';
  
  $output  =  '<div '.$id.' class="main-heading'.$class.'">';
  $output .=  '<span class="subtitle"'.$small_heading_style.'>'.esc_html($small_heading).'</span>';
  $output .=  '<h2 class="title"'.$big_heading_style.'>'.esc_html($big_heading).'</h2>';
  $output .=  '</div>';

  return $output;
}

add_shortcode('rs_section_heading', 'rs_section_heading');
