<?php
/**
 *
 * RS Hero Slider
 * @since 1.0.0
 * @version 1.0.0
 *
 *
 */
function rs_hero_slider( $atts, $content = '', $id = '' ) {
  global $rs_hero_slider;
  $rs_hero_slider = array();
  extract( shortcode_atts( array(
    'id'                  => '',
    'class'               => '',
    'style'               => 'style1',
    'big_heading_color'   => '',
    'autoplay'            => 'false',
    'speed'               => '5000',
    'loop'                => 'false',
    'height'              => 'small',
    'small_heading_color' => '',
  ), $atts ) );

  do_shortcode( $content );

  if( empty( $rs_hero_slider ) ) { return; }

  $output              = '';
  $id                  = ( $id ) ? ' id="'. esc_attr($id) .'"' : '';
  $class               = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $big_heading_color   = ($big_heading_color) ? ' style="color:'.esc_attr($big_heading_color).';"':'';
  $small_heading_color = ($small_heading_color) ? ' style="color:'.esc_attr($small_heading_color).';"':'';
  $booking_output      = '';
  switch ($style) {
    case 'style1':
      if(class_exists('WP_Hotel_Booking')):
        ob_start();
        $booking_output  =  '<div class="hero-additional">';
        $booking_output .=  '<div class="container">';
        $booking_output .=  do_shortcode('[hotel_booking show_title="false" show_label="true"]');
        $booking_output .=  '</div>';
        $booking_output .=  '</div>';
        $booking_output .= ob_get_clean();
      endif;
      $output .=  '<div '.$id.' class="hero-slider hero-slider--booking '.$class.$style.' hero-slider__'.$height.'" data-autoplay="'.esc_attr($autoplay).'" data-loop="'.esc_attr($loop).'" data-speed="'.esc_attr($speed).'">';
      $output .=  '<div class="hero-slider__items">';
      foreach ($rs_hero_slider as $key => $slide) {
        $image_id      = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $small_heading = (isset($slide['atts']['small_heading'])) ? $slide['atts']['small_heading']:'';
        $big_heading   = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $overlay       = (isset($slide['atts']['overlay'])) ? $slide['atts']['overlay']:'no';
        $overlay_class = ($overlay == 'yes') ? ' has-overlay':'';
        $btn_text      = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'';
        $btn_link      = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        $image_url     = rs_get_image_src($image_id);
        if(!empty($image_url)):
          $output .=  '<div class="hero-slider__item'.luxe_sanitize_html_classes($overlay_class).'" style="background-image: url('.esc_url($image_url).');">';
          $output .=  '<div class="hero-slider__wrap jumbotron-text__content">';
          $output .=  '<div class="subtitle subtitle--slider"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
          $output .=  '<div class="title title--slider"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
          $output .=  (!empty($btn_text)) ? '<div class="hero-slider__btn__wrapper text-center"><a href="'.esc_url($href).'" target="'.esc_attr($target).'" title="'.esc_attr($btn_title).'" class="hero-slider__btn">'.esc_html($btn_text).'</a></div>':'';
          $output .=  '</div>';
          $output .=  '</div>';
        endif;
      }
      $output .=  '</div>';
      $output .=  $booking_output;
      /* here is for hotel form */
      $output .=  '</div>';
      break;

    case 'style2':
      if(class_exists('WP_Hotel_Booking')):
        ob_start();
        $booking_output =  '<div class="hero-additional form-style2">';
        $booking_output .=  do_shortcode('[hotel_booking show_title="false" show_label="true"]');
        $booking_output .=  '</div>';
        $booking_output .= ob_get_clean();
      endif;
      $output .=  '<div '.$id.' class="hero-slider hero-slider--booking-right '.$class.$style.' hero-slider__'.$height.'" data-autoplay="'.esc_attr($autoplay).'" data-loop="'.esc_attr($loop).'" data-speed="'.esc_attr($speed).'">';
      $output .=  '<div class="hero-slider__items">';

      foreach ($rs_hero_slider as $key => $slide) {
        $image_id      = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $small_heading = (isset($slide['atts']['small_heading'])) ? $slide['atts']['small_heading']:'';
        $big_heading   = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $overlay       = (isset($slide['atts']['overlay'])) ? $slide['atts']['overlay']:'no';
        $overlay_class = ($overlay == 'yes') ? ' has-overlay':'';
        $image_url     = rs_get_image_src($image_id);
        $btn_text      = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'';
        $btn_link      = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        if(!empty($image_url)):
          $output .=  '<div class="hero-slider__item'.luxe_sanitize_html_classes($overlay_class).'" style="background-image: url('.esc_url($image_url).');">';
          $output .=  '<div class="hero-slider__wrap jumbotron-text__content">';
          $output .=  '<div class="container">';
          $output .=  '<div class="title title--slider-2"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
          $output .=  '<div class="subtitle subtitle--slider-3"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
          $output .=  (!empty($btn_text)) ? '<div class="hero-slider__btn__wrapper text-center"><a href="'.esc_url($href).'" target="'.esc_attr($target).'" title="'.esc_attr($btn_title).'" class="hero-slider__btn">'.esc_html($btn_text).'</a></div>':'';
          $output .=  '</div>';
          $output .=  '</div>';
          $output .=  '</div>';
        endif;
      }

      $output .=  '</div>';

      $output .=  '<div class="hero-tabs hero-tabs--right">';
      $output .=  '<div class="hero-tabs-wrap">';
      $output .=  '<div class="hero-tabs__items">';

      $output .= $booking_output;

      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      $output .=  '</div>';
      break;

    case 'style3':
      if(class_exists('WP_Hotel_Booking')):
        ob_start();
        $booking_output  =  '<div class="hero-additional form-style3">';
        $booking_output .=  '<div class="container">';
        $booking_output .=  do_shortcode('[hotel_booking show_title="false" show_label="true"]');
        $booking_output .=  '</div>';
        $booking_output .=  '</div>';
        $booking_output .= ob_get_clean();
      endif;
      $output .=  '<div '.$id.' class="hero-slider hero-slider--boxed '.$class.$style.' hero-slider__'.$height.'" data-autoplay="'.esc_attr($autoplay).'" data-loop="'.esc_attr($loop).'" data-speed="'.esc_attr($speed).'">';
      $output .=  '<div class="hero-slider__items">';
      foreach ($rs_hero_slider as $key => $slide) {
        $image_id      = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $small_heading = (isset($slide['atts']['small_heading'])) ? $slide['atts']['small_heading']:'';
        $big_heading   = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $overlay       = (isset($slide['atts']['overlay'])) ? $slide['atts']['overlay']:'no';
        $overlay_class = ($overlay == 'yes') ? ' has-overlay':'';
        $image_url     = rs_get_image_src($image_id);
        $btn_text      = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'';
        $btn_link      = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        if(!empty($image_url)):
          $output .=  '<div class="hero-slider__item'.luxe_sanitize_html_classes($overlay_class).'" style="background-image: url('.esc_url($image_url).');">';
          $output .=  '<div class="hero-slider__wrap jumbotron-text__content">';
          $output .=  '<div class="subtitle subtitle--slider"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
          $output .=  '<div class="title title--slider"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
          $output .=  (!empty($btn_text)) ? '<div class="hero-slider__btn__wrapper text-center"><a href="'.esc_url($href).'" target="'.esc_attr($target).'" title="'.esc_attr($btn_title).'" class="hero-slider__btn">'.esc_html($btn_text).'</a></div>':'';
          $output .=  '</div>';
          $output .=  '</div>';
        endif;
      }
      $output .= '</div>';
      $output .= $booking_output;
      $output .= '</div>';
      break;   

    case 'style4':
      if(class_exists('WP_Hotel_Booking')):
        ob_start();
        $booking_output  =  '<div class="hero-additional hero-date-picker-style2">';
        $booking_output .=  '<div class="container">';
        $booking_output .=  do_shortcode('[hotel_booking show_title="false" show_label="false"]');
        $booking_output .=  '</div>';
        $booking_output .=  '</div>';
        $booking_output .= ob_get_clean();
      endif;
      $output .=  '<div '.$id.' class="hero-slider hero-slider--booking '.$class.$style.' hero-slider__'.$height.'" data-autoplay="'.esc_attr($autoplay).'" data-loop="'.esc_attr($loop).'" data-speed="'.esc_attr($speed).'">';
      $output .=  '<div class="hero-slider__items">';
      foreach ($rs_hero_slider as $key => $slide) {
        $image_id      = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $small_heading = (isset($slide['atts']['small_heading'])) ? $slide['atts']['small_heading']:'';
        $big_heading   = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $overlay       = (isset($slide['atts']['overlay'])) ? $slide['atts']['overlay']:'no';
        $overlay_class = ($overlay == 'yes') ? ' has-overlay':'';
        $btn_text      = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'';
        $btn_link      = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        $image_url     = rs_get_image_src($image_id);
        if(!empty($image_url)):
          $output .=  '<div class="hero-slider__item'.luxe_sanitize_html_classes($overlay_class).'" style="background-image: url('.esc_url($image_url).');">';
          $output .=  '<div class="hero-slider__wrap jumbotron-text__content">';
          $output .=  '<div class="subtitle subtitle--slider"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
          $output .=  '<div class="title title--slider"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
          $output .=  (!empty($btn_text)) ? '<div class="hero-slider__btn__wrapper text-center"><a href="'.esc_url($href).'" target="'.esc_attr($target).'" title="'.esc_attr($btn_title).'" class="hero-slider__btn">'.esc_html($btn_text).'</a></div>':'';
          $output .=  '</div>';
          $output .=  '</div>';
        endif;
      }
      $output .=  '</div>';
      $output .=  $booking_output;
      /* here is for hotel form */
      $output .=  '</div>';
      break;

    case 'style5':
      if(class_exists('WP_Hotel_Booking')):
        ob_start();
        $booking_output  =  '<div class="hero-additional hero-date-picker-style3">';
        $booking_output .=  '<div class="container">';
        $booking_output .=  do_shortcode('[hotel_booking show_title="false" show_label="false"]');
        $booking_output .=  '</div>';
        $booking_output .=  '</div>';
        $booking_output .= ob_get_clean();
      endif;
      $output .=  '<div '.$id.' class="hero-slider hero-slider--booking '.$class.$style.' hero-slider__'.$height.'" data-autoplay="'.esc_attr($autoplay).'" data-loop="'.esc_attr($loop).'" data-speed="'.esc_attr($speed).'">';
      $output .=  '<div class="hero-slider__items">';
      foreach ($rs_hero_slider as $key => $slide) {
        $image_id      = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $small_heading = (isset($slide['atts']['small_heading'])) ? $slide['atts']['small_heading']:'';
        $big_heading   = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $overlay       = (isset($slide['atts']['overlay'])) ? $slide['atts']['overlay']:'no';
        $overlay_class = ($overlay == 'yes') ? ' has-overlay':'';
        $btn_text      = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'';
        $btn_link      = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        $image_url     = rs_get_image_src($image_id);
        if(!empty($image_url)):
          $output .=  '<div class="hero-slider__item'.luxe_sanitize_html_classes($overlay_class).'" style="background-image: url('.esc_url($image_url).');">';
          $output .=  '<div class="hero-slider__wrap jumbotron-text__content">';
          $output .=  '<div class="subtitle subtitle--slider"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
          $output .=  '<div class="title title--slider"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
          $output .=  (!empty($btn_text)) ? '<div class="hero-slider__btn__wrapper text-center"><a href="'.esc_url($href).'" target="'.esc_attr($target).'" title="'.esc_attr($btn_title).'" class="hero-slider__btn">'.esc_html($btn_text).'</a></div>':'';
          $output .=  '</div>';
          $output .=  '</div>';
        endif;
      }
      $output .=  '</div>';
      $output .=  $booking_output;
      /* here is for hotel form */
      $output .=  '</div>';
      break;

    case 'style6':
    case 'style7':
      if(!class_exists('WP_Hotel_Booking')) { return; }
      $datetime       = new DateTime('NOW');
      $tomorrow       = new DateTime('tomorrow');
      $search         = hb_get_page_permalink('search');
      $check_in_date  = hb_get_request('check_in_date');
      $check_out_date = hb_get_request('check_out_date');
      $format         = get_option('date_format');
      $adults         = hb_get_request('adults', 1);
      $max_child      = hb_get_request('max_child', 1);
      $uniqid         = uniqid();

      if ($check_in_date == '') {
        $check_in_date = '' . $datetime->format($format);
      }

      if ($check_out_date == '') {
        $check_out_date = $tomorrow->format($format);
      }

      $output .= '<div '.$id.' class="hero-slider hero-slider--booking hero-slider-full-height '.$class.$style.' hero-slider__'.$height.'" data-autoplay="'.esc_attr($autoplay).'" data-loop="'.esc_attr($loop).'" data-speed="'.esc_attr($speed).'">';
      $output .= '<div class="hero-slider__items">';
      foreach ($rs_hero_slider as $key => $slide) {
        $image_id      = (isset($slide['atts']['background'])) ? $slide['atts']['background']:'';
        $small_heading = (isset($slide['atts']['small_heading'])) ? $slide['atts']['small_heading']:'';
        $big_heading   = (isset($slide['atts']['heading'])) ? $slide['atts']['heading']:'';
        $overlay       = (isset($slide['atts']['overlay'])) ? $slide['atts']['overlay']:'no';
        $overlay_class = ($overlay == 'yes') ? ' has-overlay':'';
        $btn_text      = (isset($slide['atts']['btn_text'])) ? $slide['atts']['btn_text']:'';
        $btn_link      = (isset($slide['atts']['btn_link'])) ? $slide['atts']['btn_link']:'';
        if (function_exists('vc_parse_multi_attribute')) {
          $parse_args = vc_parse_multi_attribute($btn_link);
          $href       = ( isset($parse_args['url']) ) ? $parse_args['url'] : '#';
          $btn_title  = ( isset($parse_args['title']) ) ? $parse_args['title'] : 'button';
          $target     = ( isset($parse_args['target']) ) ? trim($parse_args['target']) : '_self';
        }
        $image_url     = rs_get_image_src($image_id);
        if(!empty($image_url)):
          $output .=  '<div class="hero-slider__item'.luxe_sanitize_html_classes($overlay_class).'" style="background-image: url('.esc_url($image_url).');">';
          $output .=  '<div class="hero-slider__wrap jumbotron-text__content">';
          $output .=  '<div class="subtitle subtitle--slider"'.$small_heading_color.'>'.wp_kses_post($small_heading).'</div>';
          $output .=  '<div class="title title--slider"'.$big_heading_color.'>'.wp_kses_post($big_heading).'</div>';
          $output .=  (!empty($btn_text)) ? '<div class="hero-slider__btn__wrapper text-center"><a href="'.esc_url($href).'" target="'.esc_attr($target).'" title="'.esc_attr($btn_title).'" class="hero-slider__btn">'.esc_html($btn_text).'</a></div>':'';
          $output .=  '</div>';
          $output .=  '</div>';
        endif;
      }
      $output .= '</div>';


      $output .= '<div class="hero-additional hero-additional-box hero-date-picker-style4 date-picker__alt">';
      $output .= '<div class="container">';
      $output .= '<div id="hotel-booking-search-' . uniqid() . '" class="hotel-booking-form">';
      $output .= '<form name="hb-search-form" action="' . esc_url($search) . '" class="hb-search-form-' . esc_attr($uniqid) . '">';
      $output .= '<ul class="hb-form-table">';

      $output .= '<li class="hb-form-field">';
      $output .= '<div class="hb-form-field-in">';
      $output .= '<label>' . luxe_translate('check-in', 'Check In') . '</label>';
      $output .= '<div class="hb-form-field-input">';
      $output .= '<input type="text" class="day" value="' . $datetime->format('d') . '" readonly />';
      $output .= '<input class="month" readonly type="text" value="' . esc_attr(date('M')) . '" /><i class="fa fa-angle-down"></i>';
      $output .= '<input type="text" name="check_in_date" id="check_in_date_' . esc_attr($uniqid) . '" class="check-date" value="' . esc_attr($check_in_date) . '" readonly />';
      $output .= '</div>';
      $output .= '</div>';
      $output .= '</li>';

      $output .= '<li class="hb-form-field">';
      $output .= '<div class="hb-form-field-in">';
      $output .= '<label>' . luxe_translate('check-out', 'Check out') . '</label>';
      $output .= '<div class="hb-form-field-input">';
      $output .= '<input type="text" class="day" value="' . $tomorrow->format('d') . '" readonly />';
      $output .= '<input class="month" readonly  type="text" value="' . esc_attr(date('M')) . '" /><i class="fa fa-angle-down"></i>';
      $output .= '<input type="text" name="check_out_date" id="check_out_date_' . esc_attr($uniqid) . '" class="check-date" value="' . esc_attr($check_out_date) . '" readonly/>';
      $output .= '</div>';
      $output .= '</div>';
      $output .= '</li>';

      $output .= '<li class="hb-form-field">';
      $output .= '<div class="text-center hb-select__field">';
      $output .= '<label>' . luxe_translate('guest', 'Guests') . '</label>';
      $output .= '<div class="hb-form-field-input hb-guest-field">';
      $output .= '<input type="text" id="number" class="guest" value="01" readonly />';


      ob_start();
      hb_dropdown_numbers(
        array(
          'name' => 'adults_capacity',
          'min' => 1,
          'max' => hb_get_max_capacity_of_rooms(),
          'selected' => $adults,
          'option_none_value' => 0,
          'options' => hb_get_capacity_of_rooms()
        )
      );
      $output .= ob_get_clean();

      $output .= '<div class="hb-select__group"><span class="hb__goup"><i class="fa fa-angle-up"></i></span>';
      $output .= '<span class="hb__godown"><i class="fa fa-angle-down"></i></span></div>';
      $output .= '</div>';
      $output .= '</div>';
      $output .= '</li>';
      $output .= '</ul>';

      ob_start();
      wp_nonce_field('hb_search_nonce_action', 'nonce');
      $output .= ob_get_clean();
      $output .= '<input type="hidden" name="hotel-booking" value="results" />';
      $output .= '<input type="hidden" name="action" value="hotel_booking_parse_search_params" />';
      $output .= '<p class="hb-submit hero-additional__col hero-additional__col--btn">';
      $output .= '<button type="submit" class="btn">' . luxe_translate('book-now', 'Book Now') . '<i class="fa fa-angle-right"></i></button>';
      $output .= '</p>';
      $output .= '</form>';
      $output .= '</div>';
      $output .= '</div>';
      $output .= '</div><!--end of hero-additional-->';
      $output .= '</div>';
      break;

    default:
      # code...
      break;
  }

  return $output;

}
add_shortcode('rs_hero_slider', 'rs_hero_slider');

/**
 *
 * RS Hero Slider
 * @version 1.0.0
 * @since 1.0.0
 *
 */
function rs_hero_slider_item( $atts, $content = '', $id = '' ) {
  global $rs_hero_slider;
  $rs_hero_slider[]  = array( 'atts' => $atts, 'content' => $content );
  return;
}
add_shortcode('rs_hero_slider_item', 'rs_hero_slider_item');
