<?php
/**
 *
 * RS Google Map
 * @since 1.0.0
 * @version 1.0.0
 *
 */
function rs_google_map( $atts, $content = '', $id = '' ) {
  extract( shortcode_atts( array(
    'id'          => '',
    'class'       => '',
    'usage'       => 'with_lat_long',
    'latitude'    => '39.742043',
    'longitude'   => '-104.991531',
    'iframe_code' => '',
    'marker'      => '',
  ), $atts ) );

  $id          = ( $id ) ? ' '.esc_attr($id) : '';
  $class       = ( $class ) ? ' '. luxe_sanitize_html_classes($class) : '';
  $image_url   = rs_get_image_src($marker);
  $data_marker = (!empty($image_url)) ? ' data-marker="'.esc_url($image_url).'"':'';

  if($usage == 'iframe' && !empty($iframe_code)) {
    $output = '<div '.$id.' class="hb-google__map__iframe'.$class.'">'.rawurldecode( base64_decode( strip_tags( $iframe_code ) ) ).'</div>';
  } else {
    wp_enqueue_script('gmapsensor');
    wp_enqueue_script('gmap3');
    $output = '<div '.$data_marker.' data-lat="'.esc_attr($latitude).'" data-long="'.esc_attr($longitude).'" class="hb-map__wrapper hb-google__map'.$class.'" style="width: 100%; height: 500px;"></div>';
  }

  return $output;

}
add_shortcode('rs_google_map', 'rs_google_map');
