<?php
/**
 * Service custom posty type
 */
$labels = array(
  'name'               => _x( 'Service', 'Items','luxe-addons' ),
  'singular_name'      => _x( 'Service', 'Item','luxe-addons' ),
  'add_new'            => _x( 'Add New', 'Item','luxe-addons' ),
  'add_new_item'       => esc_html__( 'Add New Item','luxe-addons' ),
  'edit_item'          => esc_html__( 'Edit Item','luxe-addons' ),
  'new_item'           => esc_html__( 'New Item','luxe-addons' ),
  'all_items'          => esc_html__( 'All Items','luxe-addons' ),
  'view_item'          => esc_html__( 'View Item','luxe-addons' ),
  'search_items'       => esc_html__( 'Search Items','luxe-addons' ),
  'not_found'          => esc_html__( 'No Items found','luxe-addons' ),
  'not_found_in_trash' => esc_html__( 'No Items found in the Trash','luxe-addons' ),
  'parent_item_colon'  => '',
  'menu_name'          => esc_html__('Services', 'luxe-addons')
);
$args = array(
  'labels'        => $labels,
  'description'   => esc_html__('Holds our products and product specific data', 'luxe-addons'),
  'public'        => true,
  'menu_position' => 21,
  'supports'      => array( 'title', 'thumbnail','editor', 'excerpt' ),
  'has_archive'   => true,

);
register_post_type( 'service', $args );

/**
 * Service category
 */
$labels = array(
  'name'              => _x( 'Categories', 'taxonomy general name', 'luxe-addons' ),
  'singular_name'     => _x( 'Category', 'taxonomy singular name', 'luxe-addons' ),
  'search_items'      => esc_html__( 'Search categories', 'luxe-addons' ),
  'all_items'         => esc_html__( 'All Categories', 'luxe-addons' ),
  'parent_item'       => esc_html__( 'Parent Category', 'luxe-addons' ),
  'parent_item_colon' => esc_html__( 'Parent Category:', 'luxe-addons' ),
  'edit_item'         => esc_html__( 'Edit Category', 'luxe-addons' ),
  'update_item'       => esc_html__( 'Update Category', 'luxe-addons' ),
  'add_new_item'      => esc_html__( 'Add New Category', 'luxe-addons' ),
  'new_item_name'     => esc_html__( 'New Category Name', 'luxe-addons' ),
  'menu_name'         => esc_html__( 'Categories' ),
);
$args = array(
  'labels' => $labels,
  'hierarchical' => true,
);
register_taxonomy( 'service-category', 'service', $args );
